#ifndef __included_action_hpp
#define __included_action_hpp

#include "billybass.hpp"

// 0.000000\t5.646050\thead
// 0.064498\t1.069177\ttail
// 0.357219\t0.580481\tmouth

#define MAX_ACTION_LINE_LENGTH 30

struct Action {
    Action(float _time = -1.0,
           bool _state = false,
           DigitalOut *_out = 0,
           char const *_outName = 0)
        : actionTime(_time)
        , output(_out)
        , desiredState(_state)
        , code('.') {
        if (_outName) code = _outName[0];
    }

    bool operator < (Action const &other) const {
        if (actionTime < other.actionTime) return true;
        if (actionTime > other.actionTime) return false;
        return (code < other.code);
    }

    // return <0 if *p1 is before *p2
    static int compare(const void* p1, const void* p2) {
        float tdiff = static_cast<Action const *>(p1)->actionTime - static_cast<Action const *>(p2)->actionTime;
        if (tdiff != 0.0) return tdiff;
        return static_cast<Action const *>(p1)->code - static_cast<Action const *>(p2)->code;
    }

    bool isValid() const {
        return actionTime >= 0.0 && output != 0;
    }

    void act() {
        output->write(desiredState ? 1 : 0);
    }

    bool isPast(float _now) {
        return _now >= actionTime;
    }

    bool actIfPast(float _now) {
        if (isPast(_now)) {
            act();
            return true;
        } else return false;
    }

    void set(float _time, int _state, DigitalOut* _out, char _code = '.') {
        actionTime = _time;
        desiredState = _state;
        output = _out;
        code = _code;
    }

    float actionTime;
    DigitalOut *output;
    uint8_t desiredState;
    char code;
};

#endif
