#include "Debug.h"

// create object of class Debug_register
//------------------------------------------------------------------------------------------------------------------ 
Debug_register_print::Debug_register_print(PinName tx_pin, PinName rx_pin, int baudrate) : pc(tx_pin,rx_pin, baudrate) {
    init();
}

// init function
//------------------------------------------------------------------------------------------------------------------ 
void Debug_register_print::init() {
    pc.printf("\ec"); // erase the whole screen
    wait_ms(50);      // wait until erasing is done
    breakpoint_count=0; // set breakpoint count to 0
    // format: 0->none, 1->hexa, 2->decimal, 3->binary(only for register value)
    count_format = 2; //binary
    line_format = 2; //binary
    address_format = 1; //hexa
    register_format = 1; //hexa

}


// perform one breakpoint and print one register
//------------------------------------------------------------------------------------------------------------------  
void Debug_register_print::breakpoint(int line_number, uint32_t address, int number_of_words){

    breakpoint_count++;

    for (int i = 0; i < abs(number_of_words); i++){
        
        // print breakpoint count according to format
        if( count_format == 1){
            pc.printf("Break no. 0x%3x  ",breakpoint_count);
        }else if( count_format == 2){
            pc.printf("Break no. %3d  ",breakpoint_count);
        }
        // print line number according to format
        if( line_format == 1){
            pc.printf("Line no. 0x%3x  ",line_number);
        }else if( line_format == 2){
            pc.printf("Line no. %3d  ",line_number);
        }
        
        // print address according to format
        if( address_format == 1){
            pc.printf("Address 0x%8x  ", address - address % 4);
        }else if( address_format == 2){
            pc.printf("Address %10u  ", address - address % 4);
        }
        
        // get value of register from address
        uint32_t reg = *((volatile unsigned int *)(address - address % 4));

        // print register value according to format
        if( register_format == 1){ // in hexa
            pc.printf("Value 0x%8x  ", reg);
        }else if( register_format == 2){ // in dedcimal
            pc.printf("Value %10u  ", reg);
        }else if( register_format == 3){ // binary
            pc.printf("Value ");
            for (int i = 0; i < 32; i++){ // print reg value in binary
                if (i%4 == 0) pc.printf(" "); // print space after four characters
                pc.printf("%d",reg >> (31 - i));
                reg -= ((reg >> (31 - i)) << (31 - i));
            }
        }
        pc.printf("\n\r");
        // increment/decrement address if if there are more registers to read
        if (number_of_words > 0){
            address += 4;
        }else{
            address -= 4;            
        }
        
    }

}

void Debug_register_print::format(int break_number, int line, int address, int value){
    // possible format: 0->none, 1->heca, 2->decimal, 3->binary(only for reg_value)
    count_format = break_number; 
    line_format = line;
    address_format = address; 
    register_format = value;

}
