#include "Debug.h"

// create object of class Debug_led
//------------------------------------------------------------------------------------------------------------------
Debug_led::Debug_led(PinName led_pin, PinName button_pin, button_mode mode) : led(led_pin, 0),button(button_pin) {
    init(mode);
}

// init function
//------------------------------------------------------------------------------------------------------------------
void Debug_led::init(button_mode mode) {
    end_breakpoint = false;
//    number_of_breakpoints = 0;
    b_mode = mode;
    
    // change mode and set up interrupt handler for button pin
    if (mode == VDD || mode ==BUTTON_VDD || mode == VCC || mode == BUTTON_VCC ){ //debug button is connected to VDD
        button.mode(PullDown); // set internal pull-down for button connected to VCC
        button.rise(callback(this, &Debug_led::end_break));// set IRQ function for rising edge of pin button
    }else{ // debug button is connected to GND
        button.mode(PullUp); // set internal pull-up for button connected to GND
        button.fall(callback(this, &Debug_led::end_break)); // set IRQ function for falling edge of pin button
    }

}

// perform one breakpoint
//------------------------------------------------------------------------------------------------------------------
void Debug_led::breakpoint(int number, int period_ms) {
//    number_of_breakpoints++; //increment number of breakpoints
    led = 0;
    while(button == b_mode){ //wait until the button is released from the previous brakpoint
        wait(0.1);    
    }
    wait(0.1); //debounce time
    
    end_breakpoint = false;    
    button.enable_irq(); //enable interrupt for button
    period_ms = (int)(period_ms/2);
    while (!end_breakpoint){ // LED is periodically flashing until the button is pushed
        
        wait_ms(3*period_ms);// wait for visibility of periodical flashing
        for(int i = 0; i < (number); i++){
            led = 1;
            wait_ms(period_ms);
            led = 0;
            wait_ms(period_ms);
    
        }
        led = 0;
    }
    while(button == b_mode){ //wait until the button is released
        wait(0.1);    
    }
    wait(0.1); //debounce time
    
}

// flash n times with breakpoint led with period 2*wait_time_ms
//------------------------------------------------------------------------------------------------------------------
//void Debug_led::flash_n_times(int wait_time_ms, int n) {
//    led = 0;
//    wait_ms(4*wait_time_ms);// wait for visibility of periodical flashing
//    for(int i = 0; i < 2*n; i++){
//        led = !led;
//        wait_ms(wait_time_ms/2);
//
//    }
//    wait_ms(3*wait_time_ms);// wait for visibility of periodical flashing
//}

// IRQ function after pushing the button
//------------------------------------------------------------------------------------------------------------------
void Debug_led::end_break() {
    button.disable_irq(); //disable interrupt until the next breakpoint
    end_breakpoint = true;    
}



