#include "mbed.h"
#include "Adafruit_SSD1306.h"

#define NUMFLAKES 10
#define XPOS 0
#define YPOS 1
#define DELTAY 2


#define LOGO16_GLCD_HEIGHT 16 
#define LOGO16_GLCD_WIDTH  16 
//static const unsigned char PROGMEM logo16_glcd_bmp[] ={        B00000000, B00110000 };
    uint8_t logo16_glcd_bmp[32] =
    { 
        0x00, 0xC0, 0x01, 0xC0, 0x01, 0xC0, 0x03, 0xE0, 0xE3, 0xE0, 0xFE, 0xF8, 0xFE, 0xFF, 0x33, 0x9F, 0x1F, 0xFC, 0x0D, 0x70, 0x1B, 0xA0, 0x3F, 0xE0, 0x3F, 0xF0, 0x7C, 0xF0, 0x70, 0x70, 0x00, 0x30
    };
DigitalOut myled_R(LED1);

I2C i2c(PA_10,PA_9);//sda,scl(PA_10,PA_9)

Adafruit_SSD1306_I2c myOled(i2c,PB_7,0x7A,64,128);//0x3D+SA0+RW
Serial pc(SERIAL_TX, SERIAL_RX);

void testdrawbitmap(const uint8_t *bitmap, uint8_t w, uint8_t h) {
  uint8_t icons[NUMFLAKES][3];
 
  // initialize
  for (uint8_t f=0; f< NUMFLAKES; f++) {
    icons[f][XPOS] = rand()%myOled.width();
    icons[f][YPOS] = 0;
    icons[f][DELTAY] = rand()%5 + 1;
    
     pc.printf("x: %d",icons[f][XPOS]);
    // pc.printf(icons[f][XPOS], DEC);
     pc.printf(" y: %d",icons[f][YPOS]);
     //pc.printf(icons[f][YPOS], DEC);
     pc.printf(" dy: %d",icons[f][DELTAY]);
     //pc.printfln(icons[f][DELTAY], DEC);
  }

  while (1) {
    // draw each icon
    for (uint8_t f=0; f< NUMFLAKES; f++) {
      myOled.drawBitmap(icons[f][XPOS], icons[f][YPOS], bitmap, w, h, WHITE);
    }
    myOled.display();
    wait(0.5);
    
    // then erase it + move it
    for (uint8_t f=0; f< NUMFLAKES; f++) {
      myOled.drawBitmap(icons[f][XPOS], icons[f][YPOS], bitmap, w, h, BLACK);
      // move it
      icons[f][YPOS] += icons[f][DELTAY];
      // if its gone, reinit
      if (icons[f][YPOS] > myOled.height()) {
        icons[f][XPOS] = rand()%myOled.width();
        icons[f][YPOS] = 0;
        icons[f][DELTAY] = rand()%5 + 1;
      }
    }
   }
}


void testdrawchar(void) {
  myOled.setTextSize(1);
  myOled.setTextColor(WHITE);
  myOled.setTextCursor(0,0);
  for (uint8_t i=0; i < 168; i++) {
    if (i == '\n') continue;
    myOled.writeChar(i);
    if ((i > 0) && (i % 21 == 0))
      myOled.printf("\n");
  }    
  myOled.display();
  wait(0.5);
}

void testdrawcircle(void) {
  for (int16_t i=0; i<myOled.height(); i+=2) {
    myOled.drawCircle(myOled.width()/2, myOled.height()/2, i, WHITE);
    myOled.display();
    wait(0.5);
  }
}

void testfillrect(void) {
  uint8_t color = 1;
  for (int16_t i=0; i<myOled.height()/2; i+=3) {
    // alternate colors
    myOled.fillRect(i, i, myOled.width()-i*2, myOled.height()-i*2, color%2);
    myOled.display();
    wait(0.5);
    color++;
  }
}

void testdrawtriangle(void) {
  for (int16_t i=0; i<min(myOled.width(),myOled.height())/2; i+=5) {
    myOled.drawTriangle(myOled.width()/2, myOled.height()/2-i,
                     myOled.width()/2-i, myOled.height()/2+i,
                     myOled.width()/2+i, myOled.height()/2+i, WHITE);
    myOled.display();
    wait(0.5);
  }
}

void testfilltriangle(void) {
  uint8_t color = WHITE;
  for (int16_t i=min(myOled.width(),myOled.height())/2; i>0; i-=5) {
    myOled.fillTriangle(myOled.width()/2, myOled.height()/2-i,
                     myOled.width()/2-i, myOled.height()/2+i,
                     myOled.width()/2+i, myOled.height()/2+i, WHITE);
    if (color == WHITE) color = BLACK;
    else color = WHITE;
    myOled.display();
    wait(0.5);
  }
}

void testdrawroundrect(void) {
  for (int16_t i=0; i<myOled.height()/2-2; i+=2) {
    myOled.drawRoundRect(i, i, myOled.width()-2*i, myOled.height()-2*i, myOled.height()/4, WHITE);
    myOled.display();
    wait(0.5);
  }
}

void testfillroundrect(void) {
  uint8_t color = WHITE;
  for (int16_t i=0; i<myOled.height()/2-2; i+=2) {
    myOled.fillRoundRect(i, i, myOled.width()-2*i, myOled.height()-2*i, myOled.height()/4, color);
    if (color == WHITE) color = BLACK;
    else color = WHITE;
    myOled.display();
    wait(0.5);
  }
}
   
void testdrawrect(void) {
  for (int16_t i=0; i<myOled.height()/2; i+=2) {
    myOled.drawRect(i, i, myOled.width()-2*i, myOled.height()-2*i, WHITE);
    myOled.display();
    wait(0.5);
  }
}

void testdrawline() {  
  for (int16_t i=0; i<myOled.width(); i+=4) {
    myOled.drawLine(0, 0, i, myOled.height()-1, WHITE);
    myOled.display();
    wait(0.5);
  }
  for (int16_t i=0; i<myOled.height(); i+=4) {
    myOled.drawLine(0, 0, myOled.width()-1, i, WHITE);
    myOled.display();
    wait(0.5);
  }
  wait(0.25);
  
  myOled.clearDisplay();
  for (int16_t i=0; i<myOled.width(); i+=4) {
    myOled.drawLine(0, myOled.height()-1, i, 0, WHITE);
    myOled.display();
    wait(0.5);
  }
  for (int16_t i=myOled.height()-1; i>=0; i-=4) {
    myOled.drawLine(0, myOled.height()-1, myOled.width()-1, i, WHITE);
    myOled.display();
    wait(0.5);
  }
  wait(0.25);
  
  myOled.clearDisplay();
  for (int16_t i=myOled.width()-1; i>=0; i-=4) {
    myOled.drawLine(myOled.width()-1, myOled.height()-1, i, 0, WHITE);
    myOled.display();
    wait(0.5);
  }
  for (int16_t i=myOled.height()-1; i>=0; i-=4) {
    myOled.drawLine(myOled.width()-1, myOled.height()-1, 0, i, WHITE);
    myOled.display();
    wait(0.5);
  }
  wait(0.25);

  myOled.clearDisplay();
  for (int16_t i=0; i<myOled.height(); i+=4) {
    myOled.drawLine(myOled.width()-1, 0, 0, i, WHITE);
    myOled.display();
    wait(0.5);
  }
  for (int16_t i=0; i<myOled.width(); i+=4) {
    myOled.drawLine(myOled.width()-1, 0, i, myOled.height()-1, WHITE); 
    myOled.display();
    wait(0.5);
  }
  wait(0.25);
}

void testscrolltext(void) {
  myOled.setTextSize(2);
  myOled.setTextColor(WHITE);
  myOled.setTextCursor(10,0);
  myOled.clearDisplay();
  myOled.printf("scroll");
  myOled.display();
  wait(0.5);
 
  myOled.startscrollright(0x00, 0x0F);
  wait(0.5);
  myOled.stopscroll();
  wait(0.5);
  myOled.startscrollleft(0x00, 0x0F);
  wait(0.5);
  myOled.stopscroll();
  wait(0.5);    
  myOled.startscrolldiagright(0x00, 0x07);
  wait(0.5);
  myOled.startscrolldiagleft(0x00, 0x07);
  wait(0.5);
  myOled.stopscroll();
}

int main()
{   
  //  uint16_t x=0;
   // pc.printf("Hello World !\n");
    //pc.printf("%ux%u \nHellow World\r\n", myOled.width(), myOled.SD_I2C_ADDRESS());
    myOled.begin();
    // Show image buffer on the display hardware.
  // Since the buffer is intialized with an Adafruit splashscreen
  // internally, this will display the splashscreen.
  myOled.display();
  wait(2);

  // Clear the buffer.
  myOled.clearDisplay();

  // draw a single pixel
  myOled.drawPixel(10, 10, WHITE);
  // Show the display buffer on the hardware.
  // NOTE: You _must_ call display after making any drawing commands
  // to make them visible on the display hardware!
  myOled.display();
  wait(2);
  myOled.clearDisplay();

  // draw many lines
  testdrawline();
  myOled.display();
  wait(2);
  myOled.clearDisplay();

  // draw rectangles
  testdrawrect();
  myOled.display();
  wait(1);
  myOled.clearDisplay();

  // draw multiple rectangles
  testfillrect();
  myOled.display();
  wait(1);
  myOled.clearDisplay();

  // draw mulitple circles
  testdrawcircle();
  myOled.display();
  wait(2);
  myOled.clearDisplay();

  // draw a white circle, 10 pixel radius
  myOled.fillCircle(myOled.width()/2, myOled.height()/2, 10, WHITE);
  myOled.display();
  wait(2);
  myOled.clearDisplay();

  testdrawroundrect();
  wait(2);
  myOled.clearDisplay();

  testfillroundrect();
  wait(2);
  myOled.clearDisplay();

  testdrawtriangle();
  wait(2);
  myOled.clearDisplay();
   
  testfilltriangle();
  wait(2);
  myOled.clearDisplay();

  // draw the first ~12 characters in the font
  testdrawchar();
  myOled.display();
  wait(2);
  myOled.clearDisplay();

  // draw scrolling text
  testscrolltext();
  wait(2);
  myOled.clearDisplay();

  // text display tests
  myOled.setTextSize(1);
  myOled.setTextColor(WHITE);
  myOled.setTextCursor(0,0);
  //myOled.setCursor(0,0);
  myOled.printf("Hello, world!");
  myOled.setTextColor(BLACK, WHITE); // 'inverted' text
  myOled.printf("3.141592");
  myOled.setTextSize(2);
  myOled.setTextColor(WHITE);
  myOled.printf("0x",0xDEADBEEF);// myOled.printf(0xDEADBEEF, HEX);
  myOled.display();
  wait(0.5);
  myOled.clearDisplay();

  // miniature bitmap display
  //myOled.drawBitmap(30, 16,  logo16_glcd_bmp, 16, 16, 1);
  myOled.display();
  wait(0.5);

  // invert the display
  myOled.invertDisplay(true);
  wait(0.5);
  myOled.invertDisplay(false);
  wait(0.5);
  myOled.clearDisplay();

  // draw a bitmap icon and 'animate' movement
  testdrawbitmap(logo16_glcd_bmp, LOGO16_GLCD_HEIGHT, LOGO16_GLCD_WIDTH);
   /* while(1)
    {
        //myOled.drawPixel(x, 32, 1);
       // myOled.drawCircle(64,32,20,1);
       // myOled.drawFastVLine(125,2,50,1);
        //myled_R = !myled_R;
        //myOled.printf("%u\r",x);
        //myOled.display();
        //x = x + 1;                  
        //wait(0.5);
    }*/
}
