#ifndef FLASHER_H
#define FLASHER_H
 
#include "mbed.h"

/**Flasher class
 * Used to flash a pin # times
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "Flasher.h"
 *
 * Flasher led(LED2);
 * 
 * int main() {
 *    led.flash(5); //flash LED2 5 times
 * } 
 * @endcode
 */
class Flasher {
public:
    /**Create Flasher instance
     *
     *@param pin Mbed pin reference
     */    
    Flasher(PinName pin);
    
    /**Flash method
    *
    *@param n Number of flashes to perform
    */
    void flash(int n);
  
private:  
    DigitalOut _pin;
};
 
#endif