#include "mbed.h"
#include "ESP8266.h"
#include <string.h>
#include <stdio.h>
#include "GroveEarbudSensor.h"

#define APIKEY SJYFHXQEDBQ75N91    //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
#define WIFI_SSID "BHNTG1682GF6C2"
#define WIFI_PASS "ef8df304"
#define sendnumber "3178208811"

char snd[255],rcv[1000],snd_Data[255];
float hrt;

ESP8266 esp(PTC17, PTC16, 115200); // baud rate for wifi
Serial pc(USBTX, USBRX);

// callback for receiving heartrate values 
void heartrateCallback(float heartrate,void *data) 
{
         printf("Callback: heartrate = %.1f\r\n",heartrate);
}  

// Blinky
DigitalOut led(LED1);

// Our sensor as an InterruptIn
InterruptIn sensor(D2);

GroveEarbudSensor earbud(&sensor); 

void esp_initialize(void);
void esp_send(void);

int main(void)
{   
pc.baud(115200);
    esp_initialize();
    
    // announce
    printf("Grove Earbud Sensor Example v1.0.0\r\n");
    
    // allocate the earbud sensor
    printf("Allocating earbud sensor instance...\r\n");
    
     // register our callback function     
     printf("registering callback...\r\n");     
     earbud.registerCallback(heartrateCallback); 
    
    // begin main loop
    printf("Beginning main loop...\r\n");
    while (true) 
    {
        // blink... 
        led = !led; 
        wait(1);
           
    // we can also call directly 
 printf("Direct: heartrate = %.1f\r\n", earbud.getHeartRate());
 
 }
 }
void esp_initialize(void)
{
    pc.printf("Initializing ESP\r\n");

    pc.printf("Reset ESP\r\n");
    esp.Reset();                   //RESET ESP
    esp.RcvReply(rcv, 400);        //receive a response from ESP
    wait(2);

    strcpy(snd,"AT");
    esp.SendCMD(snd);
    pc.printf(snd);
    esp.RcvReply(rcv, 400);
    pc.printf(rcv);
    wait(0.1);

    strcpy(snd,"AT+CWMODE=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(2);

    strcpy(snd,"AT+CWJAP=\"");
    strcat(snd,WIFI_SSID);
    strcat(snd,"\",\"");
    strcat(snd,WIFI_PASS);
    strcat(snd,"\"");


    esp.SendCMD(snd);
    pc.printf(snd);
    wait(5);
    esp.RcvReply(rcv, 400);
    pc.printf("\n %s \n", rcv);

    strcpy(snd,"AT+CIPMUX=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    esp.RcvReply(rcv, 400);
    pc.printf("\n %s \n", rcv);

}
void esp_send(void)
{
    //ESP updates the Status of Thingspeak channel//

    strcpy(snd,"AT+CIPSTART=");
    strcat(snd,"\"TCP\",\"");
    strcat(snd,IP);
    strcat(snd,"\",80");

    esp.SendCMD(snd);
    pc.printf("Send\r\n%s",snd);
    esp.RcvReply(rcv, 1000);
    pc.printf("Receive\r\n%s",rcv);
    wait(1);

    hrt = earbud.getHeartRate();
    pc.printf("Sending this data to thingspeak.com \r \n");
    sprintf(snd,"GET https://api.thingspeak.com/update?api_key=SJYFHXQEDBQ75N91&field1=%f\r\n", hrt);

    int i=0;
    for(i=0; snd[i]!='\0'; i++);
    i++;
    char cmd[255];

    sprintf(cmd,"AT+CIPSEND=%d",i);           //Send Number of open connection and Characters to send
    esp.SendCMD(cmd);
    pc.printf("Send\r\n%s",cmd);
    while(i<=20 || rcv == ">")
 {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("Receive\r\n%s",rcv);

    esp.SendCMD(snd);       //Post value to thingspeak channel
    pc.printf("Send\r\n%s",snd);

    while(i<=20 || rcv == "OK") 
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("Receive\r\n%s",rcv);
}


