
#include "mbed.h"
#include "platform/mbed_thread.h"
#include <string.h>

// PWM Frequency
#define PFREQ .5


Serial pc(USBTX, USBRX); // tx, rx
PwmOut p1(PA_8);

int main()
{
    char cmd[80];
    char ch;
    unsigned char index = 0;

    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    p1.period((float)1/PFREQ);
    p1.write(0.0);
    pc.printf("\n\rMotor> ");    
    while (true) {
        
        ch = pc.getc();
        index = 0;
        while ((ch != '\n') && (ch != '\r')) {
            pc.putc(ch);
            cmd[index++] = ch;
            ch = pc.getc();
        }   
        cmd[index] = 0;
        if (!strcmp(cmd,"lon")) {
            led = 1;
        }   
        else if (!strcmp(cmd,"lof")) {
            led = 0;
        }
        else if (!strcmp(cmd,"high")) {
            p1.write(1.0);  
        }
        else if (!strcmp(cmd,"med")) {
            p1.write(0.5);  
        }
        else if (!strcmp(cmd,"low")) {
            p1.write(0.15);  
        }
        else if (!strcmp(cmd,"off")) {
            p1.write(0.0);  
        }
        
        pc.printf("\n\r");
        pc.printf("Motor> ");
    }
}

