/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include <string.h>
#include "LPS331_I2C.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

Serial pc(USBTX, USBRX); // tx, rx
LPS331_I2C lps331(PB_7, PB_6, LPS331_I2C_SA0_HIGH);

int main()
{
    char cmd[80];
    char ch;
    unsigned char index = 0;

    if(lps331.isAvailable()) {
        pc.printf("LPS331 is available!\r\n");
    } else {
        pc.printf("LPS331 is unavailable!\r\n");
    }

    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    pc.printf("L432> ");    
    while (true) {
        
        ch = pc.getc();
        index = 0;
        while ((ch != '\n') && (ch != '\r')) {
            pc.putc(ch);
            cmd[index++] = ch;
            ch = pc.getc();
        }   
        cmd[index] = 0;
        if (!strcmp(cmd,"lon")) {
            led = 1;
        }   
        else if (!strcmp(cmd,"lof")) {
            led = 0;
        }
        pc.printf("\n\r",cmd);
        pc.printf("L432> ");
    }
}

/* 
#include "LPS331_I2C.h"

Serial pc(USBTX, USBRX);
LPS331_I2C lps331(p9, p10, LPS331_I2C_SA0_HIGH);


int main() {
    pc.printf("LPS331 Test Program.\r\n");
    
    if(lps331.isAvailable()) {
        pc.printf("LPS331 is available!\r\n");
    } else {
        pc.printf("LPS331 is unavailable!\r\n");
    }
    
    lps331.setResolution(LPS331_I2C_PRESSURE_AVG_512, LPS331_I2C_TEMP_AVG_128);
    lps331.setDataRate(LPS331_I2C_DATARATE_7HZ);
    lps331.setActive(true);
    
    pc.printf("LPS331 Register map.\r\n");

    for(int i = 0; i < 8; i++) {
        pc.printf("%02x: ", i);
        for(int j = 0; j < 16; j++) {
            char value = lps331._read(j | i << 4);
            pc.printf("%02x ", value);
        }
        pc.printf("\r\n");
    }
    
    pc.printf("LPS331 Register map(multibyte read test).\r\n");
    
    for(int i = 0; i < 8; i++) {
        char data[16];
        lps331._read_multibyte(i << 4, data, 16);
        pc.printf("%02x: ", i);
        for(int j = 0; j < 16; j++) {
            pc.printf("%02x ", data[j]);
        }
        pc.printf("\r\n");
    }
    
    wait(2.0);
                
    while(true) {
        float pres, temp;
        
        pres = lps331.getPressure();
        temp = lps331.getTemperature();
        
        pc.printf("%f,%f\r\n", pres, temp);
        
        wait(1/7.0);
    }
*/
