// Code used for the SP18 E210/P442 Lab Practical
#include "mbed.h"
#include "ADXL362.h"
#include "TSL2561.h"

AnalogOut my_output(PA_4);

// Interface pulled from ADXL362.cpp
// ADXL362::ADXL362(PinName CS, PinName MOSI, PinName MISO, PinName SCK) :
ADXL362 adxl362(PA_0,PA_7,PA_6,PA_1);
TSL2561 lightsensor(PB_7,PB_6);


#define PI        (3.141592653589793238462)
#define AMPLITUDE (1.0)    // x * 3.3V
#define PHASE     (PI * 1) // 2*pi is one period
#define RANGE     (0x7FFF)
#define OFFSET    (0x7FFF)

#define SPI_CYCLES 100
// Configuration for sinewave output
#define BUFFER_SIZE (360)
uint16_t buffer[BUFFER_SIZE];

void calculate_sinewave(void);

int main() {
    printf("Sinewave example\n");
    calculate_sinewave();
    adxl362.reset();
    wait_ms(1000); // we need to wait at least 500ms after ADXL362 reset
    adxl362.set_mode(ADXL362::MEASUREMENT);
    wait_ms(1000); // we need to wait at least 500ms after ADXL362 reset
    volatile int8_t x,y,z;
    volatile uint16_t whoami; 
    volatile float light;
    int spi_trigger_target = 0;
    
    while(1) {
        for (int i = 0; i < BUFFER_SIZE; i++) {
            my_output.write_u16(buffer[i]);
            wait_us(10);
        }
        x=adxl362.scanx_u8();
        y=adxl362.scany_u8();
        z=adxl362.scanz_u8();
        if (spi_trigger_target++ == SPI_CYCLES){
            spi_trigger_target = 0;
            whoami = adxl362.read_reg(ADXL362::DEVID_AD);
        } 
        light = lightsensor.lux();           
        // printf("Accelerometer x = %d y = %d z = %d\r\n",x,y,z);
        // printf("Light sensor %f\n\r",lightsensor.lux());
//        wait_ms(100);
      
    }
}

// Create the sinewave buffer
void calculate_sinewave(void){
  for (int i = 0; i < BUFFER_SIZE; i++) {
     double rads = (PI * i)/180.0; // Convert degree in radian
     buffer[i] = (uint16_t)(AMPLITUDE * (RANGE * (cos(rads + PHASE))) + OFFSET);
  }
}
