// Code taken and hacked from EasyBMP library by Paul Macklin

#include "uLCD_4DGL.h"
#include "SDFileSystem.h"

#define DefaultXPelsPerMeter 3780
#define DefaultYPelsPerMeter 3780

typedef unsigned char  ebmpBYTE;
typedef unsigned short ebmpWORD;
typedef unsigned int  ebmpDWORD;

typedef struct RGBApixel {
    ebmpBYTE Blue;
    ebmpBYTE Green;
    ebmpBYTE Red;
    ebmpBYTE Alpha;
} RGBApixel; 

typedef struct RGBpixel {
    ebmpBYTE Blue;
    ebmpBYTE Green;
    ebmpBYTE Red;
} RGBpixel; 


class BMFH{
public:
 ebmpWORD  bfType;
 ebmpDWORD bfSize;
 ebmpWORD  bfReserved1;
 ebmpWORD  bfReserved2;
 ebmpDWORD bfOffBits; 

 BMFH();
};

class BMIH{
public:
 ebmpDWORD biSize;
 ebmpDWORD biWidth;
 ebmpDWORD biHeight;
 ebmpWORD  biPlanes;
 ebmpWORD  biBitCount;
 ebmpDWORD biCompression;
 ebmpDWORD biSizeImage;
 ebmpDWORD biXPelsPerMeter;
 ebmpDWORD biYPelsPerMeter;
 ebmpDWORD biClrUsed;
 ebmpDWORD biClrImportant;

 BMIH();
};
bool ReadBMPFromFile( const char* FileName , RGBApixel *Colors, uLCD_4DGL *lcd);
bool ReadBMPFromFile(const char* FileName , RGBApixel *Colors, uLCD_4DGL *lcd, int x, int y);
// need to allocate width*height ints for color_array
// colors go from color_array[0] to color_array[width*height-1] going from i,j coord values
// accessed with color_array[width*j + i]
bool ReadColorsFromFile(const char* FileName , RGBApixel *Colors, int * color_array, int x, int y);
void DrawColorstoLCD(int * color_array, uLCD_4DGL *lcd, int x, int y, int w, int h);
