#pragma once

#include "settings.h"

#include <vector>
#include <mbed.h>
#include <DW1000.h>

#include "UWBProtocol.h"

namespace ait
{

class UWB2WayMultiRange : public UWBProtocol
{
public:
    static const float SPEED_OF_LIGHT_IN_M_PER_US = 299.792458f;

    enum RangingStatus
    {
        SUCCESS = 0,
        NO_MASTER_REQUEST_1,
        NO_SLAVE_REPLY,
        NO_MASTER_REQUEST_2,
        NO_SLAVE_REPORT,
        OTHER,
    };

    static const char* const RANGING_STATUS_MESSAGES[];

    struct RawRangingResult
    {
        RawRangingResult()
        : status(OTHER)
        {
        }

        float primary_tof;
        float primary_range;

        std::vector<uint64_t> timestamp_master_request_1;
        std::vector<uint64_t> timestamp_slave_reply;
        std::vector<uint64_t> timestamp_master_request_2;

        uint64_t timestamp_master_request_1_recv;
        uint64_t timestamp_slave_reply_send;
        uint64_t timestamp_master_request_2_recv;

        std::vector<ReceptionStats> stats;
        RangingStatus status;
        char status_description[64];
    };

    UWB2WayMultiRange(uint8_t address);

    void addModule(DW1000* dw_ptr);

    int getNumOfModules() const;

    const DW1000* getModule(int module_index) const;
    DW1000* getModule(int module_index);

    const RawRangingResult& measureTimesOfFlight(uint8_t remote_address, float timeout = 0.1f, ReceptionStats* stats = NULL);

    float convertDWTimeunitsToMicroseconds(int64_t dw_timeunits) const;
    float convertTimeOfFlightToDistance(float tof) const;

protected:
    std::vector<DW1000*> dw_array_;
    RawRangingResult raw_result_;

    bool receiveFramesBlocking(std::vector<DW1000*>& dw_array, float timeout, uint64_t* timestamp_recv = NULL, ReceptionStats* stats = NULL);
    bool receiveFramesBlocking(std::vector<DW1000*>& dw_array, uint8_t type, float timeout, uint64_t* timestamp_recv = NULL, ReceptionStats* stats = NULL);
};

}
