/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-02-17

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "mbed.h"
#include "SeeedStudioTFTv2.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

#define PIN_XP          A3
#define PIN_XM          A1
#define PIN_YP          A2
#define PIN_YM          A0
#define PIN_MOSI        D11
#define PIN_MISO        D12
#define PIN_SCLK        D13
#define PIN_CS_TFT      D5
#define PIN_DC_TFT      D6
#define PIN_BL_TFT      D7
#define PIN_CS_SD       D4

Timer t;
Serial pc(USBTX,USBRX);
SeeedStudioTFTv2 TFT(PIN_XP, PIN_XM, PIN_YP, PIN_YM, PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_DC_TFT, PIN_BL_TFT, PIN_CS_SD);

char ip0[] = {' ','0','+'};
char ip2[] = {'a','b','c','2'};
char ip3[] = {'d','e','f','3'};
char ip4[] = {'g','h','i','4'};
char ip5[] = {'j','k','l','5'};
char ip6[] = {'m','o','p','6'};
char ip7[] = {'p','q','r','s','7'};
char ip8[] = {'t','u','v','8'};
char ip9[] = {'w','x','y','z','9'};
    
char* cmd = NULL;

void printKey(int x, int y, char* digit, char* alphas)
{
    TFT.foreground(Blue);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(x,y);
    TFT.printf(digit);
    TFT.foreground(Black);
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(x+15,y+10);
    TFT.printf(alphas);
}

void initKeypad()
{
    TFT.background(White);
    TFT.cls();
    TFT.foreground(Black);
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(210,84);
    TFT.printf("Del");
    TFT.line(0,100,240,100,Black);
    TFT.rect(205,80,235,95,Black);
    TFT.line(205,80,195,95,White);
    TFT.line(192,87,205,80,Black);
    TFT.line(192,87,205,95,Black);
    printKey(20,120,"1","   ");
    printKey(95,120,"2","ABC");
    printKey(170,120,"3","DEF");
    printKey(20,160,"4","GHI");
    printKey(95,160,"5","JKL");
    printKey(170,160,"6","MNO");
    printKey(20,200,"7","PQRS");
    printKey(95,200,"8","TUV");
    printKey(170,200,"9","WXYZ");
    printKey(20,240,"*","");
    printKey(95,240,"0","+");
    printKey(170,240,"#","");
    printKey(20,280,"<--","");
}

int getKey()
{
    int key = -1;
    point p;
    int count = 0;
    if(TFT.getTouch(p) == TFT.NO || TFT.getTouch(p) == TFT.MAYBE)
    { return key;
        }
    while(TFT.getTouch(p) == TFT.YES)
    {
        count++;
    }
    if(count > 300)
    {
        //TFT.foreground(Black);
//        TFT.set_font((unsigned char*) Arial12x12);
//        TFT.locate(0,0);
//        TFT.printf("X:%d, Y:%d\n\r",p.x,p.y);
        if (p.x>2700 && p.x<7250)
        {
            if(p.x<3750)
            {
                if(p.y<3000)
                    key = 1;    //1
                else if(p.y<5250)
                    key = 2;    //2
                else
                    key = 3;    //3
            }
            else if(p.x<4600)
            {
                if(p.y<3000)
                    key = 4;    //4
                else if(p.y<5250)
                    key = 5;    //5
                else
                    key = 6;    //6
            }
            else if(p.x<5400)
            {
                if(p.y<3000)
                    key = 7;    //7
                else if(p.y<5250)
                    key = 8;    //8
                else
                    key = 9;    //9
            }
            else if(p.x<6300)
            {
                if(p.y<3000)
                    key = 42;   //*
                else if(p.y<5250)
                    key = 0;    //0
                else
                    key = 35;   //#
            }
            else
            {
                if(p.y<3000)
                    key = 60;  // back
                else
                    key = 43;   // go (call/text)
            }
        }
        if(p.x > 2200 && p.x < 2500 && p.y > 6200 && p.y < 7000)
            key = 127;
    }
    return key;
}

bool displayChar(point& cursor, char letter)
{
    TFT.locate(cursor.x,cursor.y);
    if(cursor.x + 12 <= 228)
        cursor.x += 12;
    else
    {
        cursor.x = 0;
        if(cursor.y + 21 <= 65 )
            cursor.y += 21;
        else
            return false;
    }
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.printf("%c",letter);
    return true;
}

int getAlpha(point& x, char** pt)
{
    int touchCount = 1, count = 1;
    int key, begin, end;
    int prevKey;
    do  {
        prevKey = key = getKey();
    }while(prevKey == -1 && strcmp(cmd, "Text") == 0);
        
    point cursor = x;
    char* ptr = *pt;
    t.reset();
    t.start();
    begin = t.read_ms();
    end = t.read_ms();
    while((end - begin) < 2000)
    { 
        cursor = x;
        ptr = *pt;
        touchCount = count;
START:
        switch(key)
                {
                    case 0:
                        touchCount = (touchCount-1)%(sizeof(ip0)/sizeof(ip0[0]));
                        if(displayChar(cursor, ip0[touchCount])) {
                            *ptr = ip0[touchCount];
                            ptr++;
                        }
                        break;
                    case 1:
                        if(displayChar(cursor, '1')) {
                            *ptr = '1';
                            ptr++;
                        }
                        break;
                    case 2:
                        touchCount = (touchCount-1)%(sizeof(ip2)/sizeof(ip2[0]));
                        if(displayChar(cursor, ip2[touchCount])) {
                            *ptr = ip2[touchCount];
                            ptr++;
                        }
                        break;
                    case 3:
                        touchCount = (touchCount-1)%(sizeof(ip3)/sizeof(ip3[0]));
                        if(displayChar(cursor, ip3[touchCount])) {
                            *ptr = ip3[touchCount];
                            ptr++;
                        }
                        break;
                    case 4:
                        touchCount = (touchCount-1)%(sizeof(ip4)/sizeof(ip4[0]));
                        if(displayChar(cursor, ip4[touchCount])) {
                            *ptr = ip4[touchCount];
                            ptr++;
                        }
                        break;
                    case 5:
                        touchCount = (touchCount-1)%(sizeof(ip5)/sizeof(ip5[0]));
                        if(displayChar(cursor, ip5[touchCount])) {
                            *ptr = ip5[touchCount];
                            ptr++;
                        }
                        break;
                    case 6:
                        touchCount = (touchCount-1)%(sizeof(ip6)/sizeof(ip6[0]));
                        if(displayChar(cursor, ip6[touchCount])) {
                            *ptr = ip6[touchCount];
                            ptr++;
                        }
                        break;
                    case 7:
                        touchCount = (touchCount-1)%(sizeof(ip7)/sizeof(ip7[0]));
                        if(displayChar(cursor, ip7[touchCount])) {
                            *ptr = ip7[touchCount];
                            ptr++;
                        }
                        break;
                    case 8:
                        touchCount = (touchCount-1)%(sizeof(ip8)/sizeof(ip8[0]));
                        if(displayChar(cursor, ip8[touchCount])) {
                            *ptr = ip8[touchCount];
                            ptr++;
                        }
                        break;
                    case 9:
                        touchCount = (touchCount-1)%(sizeof(ip9)/sizeof(ip9[0]));
                        if(displayChar(cursor, ip9[touchCount])) {
                            *ptr = ip9[touchCount];
                            ptr++;
                        }
                        break;
                    case 35:
                        if(displayChar(cursor, '#')) {
                            *ptr = '#';
                            ptr++;
                        }
                        break;
                    case 42:
                        if(displayChar(cursor, '*')) {
                            *ptr = '*';
                            ptr++;
                        }
                        break;
                }
        
        key = getKey();
        end = t.read_ms();
        if(key == -1 && ((end - begin) < 2000)) goto START;

        if(!(prevKey == key)){
            break;
        }
        count++;
        
        pc.printf("ok curr count :%d key : %d  prev_key : %d \r\n", touchCount,key,  prevKey);
    }
    t.stop();
    pc.printf("ok count is :%d \r\n", touchCount);
    pc.printf("PTR: %x, PT: %x\r\n",ptr,*pt);
    
    x = cursor;
    *pt = ptr;
    return prevKey;
}

int main()
{
    point p;
    bool isMsg = false;
    char numbuffer[140];
    char msgbuffer[140];
    //Configure the display driver
    TFT.background(Black);
    TFT.foreground(White);
    TFT.cls();

    while(true)
    {
        //Print a welcome message
        TFT.background(White);
        TFT.set_font((unsigned char*) Neu42x35);
        TFT.foreground(Maroon);
        TFT.cls();
        TFT.locate(100,60);
        TFT.printf("IU");
        
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(28,230);
        TFT.printf("CALL");
        TFT.circle(60,240,50,Maroon);
        
        TFT.locate(140,230);
        TFT.printf("TEXT");
        TFT.circle(180,240,50,Maroon);
    
        while((strcmp(cmd, "Back") == 0) || cmd == NULL)
        {
            if (TFT.getTouch(p) == TFT.YES)
            {
                if(p.x >= 4500 && p.x <= 6600)
                {
                    if(p.y >= 1500 && p.y <= 3800)
                    {
                        //call
                        cmd = "Call";
                    }
                    else if(p.y >= 4500 && p.y <= 7100)
                    {
                        //text
                        cmd = "Text";
                    }
                }
            }
        }
        if(strcmp(cmd, "Call") == 0) 
        {
            initKeypad();
            if(!isMsg)
                printKey(130,280,"CALL","" );
            else
                printKey(130,280,"SEND","" );
            point cursor;
            cursor.x = 0;
            cursor.y = 5;
            char *ptr = numbuffer;
            while(strcmp(cmd, "Call") == 0)
            {
                TFT.foreground(Black);
                int key = getKey();
                switch(key)
                {
                    case 0:
                        if(displayChar(cursor, '0')) {
                            *ptr = '0';
                            ptr++;
                        }
                        break;
                    case 1:
                        if(displayChar(cursor, '1')) {
                            *ptr = '1';
                            ptr++;
                        }
                        break;
                    case 2:
                        if(displayChar(cursor, '2')) {
                            *ptr = '2';
                            ptr++;
                        }
                        break;
                    case 3:
                        if(displayChar(cursor, '3')) {
                            *ptr = '3';
                            ptr++;
                        }
                        break;
                    case 4:
                        if(displayChar(cursor, '4')) {
                            *ptr = '4';
                            ptr++;
                        }
                        break;
                    case 5:
                        if(displayChar(cursor, '5')) {
                            *ptr = '5';
                            ptr++;
                        }
                        break;
                    case 6:
                        if(displayChar(cursor, '6')) {
                            *ptr = '6';
                            ptr++;
                        }
                        break;
                    case 7:
                        if(displayChar(cursor, '7')) {
                            *ptr = '7';
                            ptr++;
                        }
                        break;
                    case 8:
                        if(displayChar(cursor, '8')) {
                            *ptr = '8';
                            ptr++;
                        }
                        break;
                    case 9:
                        if(displayChar(cursor, '9')) {
                            *ptr = '9';
                            ptr++;
                        }
                        break;
                    case 35:
                        if(displayChar(cursor, '#')) {
                            *ptr = '#';
                            ptr++;
                        }
                        break;
                    case 42:
                        if(displayChar(cursor, '*')) {
                            *ptr = '*';
                            ptr++;
                        }
                        break;
                    case 43:
                        if(isMsg)
                            cmd = "Send";
                        else
                            cmd = "Make";
                        isMsg = false;
                        break;
                    case 60:
                        cmd = "Back";
                        isMsg = false;
                        break;
                    case 127:
                        if(ptr > numbuffer)
                        {
                            ptr--;
                            if(cursor.x - 12 >= 0)
                                cursor.x -= 12;
                            else
                            {
                                cursor.x = 240;
                                if(cursor.y - 21 >= 5 )
                                cursor.y -= 21;
                            }
                            TFT.locate(cursor.x,cursor.y);
                            TFT.printf(" ");
                        }
                        break;
                }
            }
            if(strcmp(cmd, "Make") == 0)
            {
                TFT.background(Black);
                TFT.foreground(White);
                TFT.cls();
                int i=0;
                cursor.x = 0;
                cursor.y = 5;
                TFT.locate(0,0);
                while(&numbuffer[i] < ptr)
                    displayChar(cursor, numbuffer[i++]);
                TFT.line(0,270,240,270,Red);
                TFT.foreground(Red);
                TFT.locate(60,280);
                TFT.set_font((unsigned char*) Arial24x23);
                TFT.printf("Hang Up");
                while(strcmp(cmd, "Make") == 0)
                {
                    if(TFT.getTouch(p) == TFT.YES && p.x >= 6300 && p.x <= 7250)
                        cmd = "Back";
                }
            }
            else if(strcmp(cmd,"Send") == 0)
            {
                // numbuffer has number
                // msgbuffer has msg
                TFT.background(Black);
                TFT.foreground(White);
                TFT.cls();
                TFT.locate(90,60);
                TFT.printf("Text %s",msgbuffer);
                TFT.locate(90,95);
                TFT.printf("Sent to %s!",numbuffer);
                wait(2.5);
                cmd = "Back";
            }
            if(strcmp(cmd, "Back") == 0)
            {
                //Home screen
            }    
        }
        else if(strcmp(cmd, "Text") == 0)
        {
            initKeypad();
            printKey(130,280,"SEND","" );
            point cursor;
            cursor.x = 0;
            cursor.y = 5;
            char *ptr = msgbuffer;
            while(strcmp(cmd, "Text") == 0)
            {
                int key = getAlpha(cursor, &ptr);
                switch(key)
                {
                    case 43:
                        isMsg = true;
                        cmd = "Call";
                        break;
                    case 60:
                        cmd = "Back";
                        break;
                    case 127:
                        pc.printf("PTR: %x, Buff: %x, Buffer: %s\r\n",ptr, &msgbuffer[0], msgbuffer);
                        
                        if(ptr > msgbuffer)
                        {
                            pc.printf("true");
                            ptr--;
                            if(cursor.x - 12 >= 0)
                                cursor.x -= 12;
                            else
                            {
                                cursor.x = 240;
                                if(cursor.y - 21 >= 5 )
                                cursor.y -= 21;
                            }
                            TFT.locate(cursor.x,cursor.y);
                            TFT.printf(" ");
                        }
                        break; 
                }
            }
        }
        else if (strcmp(cmd, "Ring") == 0)
        {
            
            TFT.background(Black);
            TFT.foreground(White);
            TFT.cls();
            TFT.locate(0,0);
            TFT.printf("Incoming Call...");
            TFT.foreground(Green);
            TFT.set_font((unsigned char*) Arial24x23);
            TFT.locate(28,230);
            TFT.printf("ANS");
            TFT.circle(60,240,50,Green);
        
            TFT.foreground(Red);
            TFT.locate(140,220);
            TFT.printf("HANG");
            TFT.locate(160,240);
            TFT.printf("UP");
            TFT.circle(180,240,50,Red);
            while(strcmp(cmd, "Ring") == 0)
            {
                if (TFT.getTouch(p) == TFT.YES)
                {
                    if(p.x >= 4500 && p.x <= 6600)
                    {
                        if(p.y >= 1500 && p.y <= 3800)
                        {
                            //answer cal
                            cmd = "Answer";
                            break;
                        }
                        else if(p.y >= 4500 && p.y <= 7100)
                        {
                            //hang up
                            cmd = "Back";
                            break;
                        }
                        
                    }
                }
            }
            if(strcmp(cmd, "Answer") == 0)
            {
                TFT.background(Black);
                TFT.foreground(White);
                TFT.cls();
                TFT.locate(0,0);
                TFT.printf("Call in Progress...");
                TFT.line(0,270,240,270,Red);
                TFT.foreground(Red);
                TFT.locate(60,280);
                TFT.set_font((unsigned char*) Arial24x23);
                TFT.printf("Hang Up");
                while(strcmp(cmd, "Answer") == 0)
                {
                    if(TFT.getTouch(p) == TFT.YES && p.x >= 6300 && p.x <= 7250)
                        cmd = "Back";
                }
            }
        }
        else if(strcmp(cmd, "RecvM") == 0)
        {
            TFT.background(White);
            TFT.foreground(Blue);
            TFT.set_font((unsigned char*) Arial24x23);
            char *start_pos, *end_pos, *msg_pos;
            start_pos = strstr(recv_msgbuffer,"+CMT: \"");
            char txtnum[20];
            gsm.cleanBuffer(txtnum,20);
            char recv_msg[140];
            gsm.cleanBuffer(recv_msg,140);
            start_pos += 7;
            if(strstr(start_pos,"\",") != NULL)
            {
                end_pos = strstr(start_pos,"\",");
                strncpy(txtnum,start_pos,(end_pos - start_pos));
                TFT.locate(0,5);
                TFT.printf("\r\nFrom: %s \r\n",txtnum);
            }
            if(strstr(start_pos,"\n") != NULL)
            {
                msg_pos = strstr(start_pos,"\n");
                if(strstr(msg_pos+1,"\n") != NULL)
                {
                    end_pos = strstr(msg_pos+1,"\n");
                    strncpy(recv_msg,msg_pos+1,(end_pos - msg_pos - 1));
                    TFT.locate(0,100);
                    TFT.printf("Message: %s\r\n",recv_msg);
                }
            }
            TFT.line(0,270,240,270,Red);
            TFT.foreground(Blue);
            TFT.locate(60,280);
            TFT.set_font((unsigned char*) Arial24x23);
            TFT.printf("OK");
            while(strcmp(cmd, "RecvM") == 0)
            {
                if(TFT.getTouch(p) == TFT.YES && p.x >= 6300 && p.x <= 7250)
                    cmd = "Back";
            }
        }
    }
}
