#include "mbed.h"
#include "mbed_rpc.h"

Serial pc(USBTX, USBRX);

int main() {
    // setup the classes that can be created dynamically
    RPC::add_rpc_class<RpcAnalogIn>();
    
    RPC::add_rpc_class<RpcDigitalIn>();
    RPC::add_rpc_class<RpcDigitalOut>();
    
    RPC::add_rpc_class<RpcPwmOut>();
    
    RpcAnalogIn rpc_ain(p19, "ain");
    RpcDigitalOut rpc_led(LED1, "led");
    RpcPwmOut rpc_pwmout(p10, "pwmout");
    
    // receive commands, and send back the responses
    char buf[256], outbuf[256];    
    
    while(1) {
        pc.gets(buf, 256);
        RPC::call(buf, outbuf);
        pc.printf("%s\n", outbuf);
    }
}
/*
void myRPCAnalogIn(Arguments* input, Reply* output){
    output->putData(ain.read());
    led3 = 1;
    wait(2);
    led3 = 0;
}
*/