/*****************************************************************************/
/*                                   USB MOUSE HOST                          */
/*Function: This program is used to connect the MBED USB mouse. The bubble   */
/*          on the LCD moves according to the input from the USB device.     */
/*          The program for the MBED USB Device can be found at following    */
/*          location:                                                        */
/*          <http://mbed.org/users/bhakti08/code/USB_Project_Device/>        */
/*Author:   Bhakti Kulkarni                                                  */
/*Date:     03/27/2014                                                       */
/*****************************************************************************/

#include "mbed.h"
#include "USBHostMouse.h"
#include "C12832_lcd.h"
#include "DebouncedInterrupt.h"
#include "DebouncedIn.h"

DigitalOut connect(LED1);     //LED to indicate USB Mouse connected
C12832_LCD lcd;
Serial pc(USBTX,USBRX);
BusOut button (LED2,LED3,LED4);   //LEDs for the Button pressed on Device

/*Global Variables to process the X abd Y values*/
int x_lcd=0,y_lcd=0;
int Xpos=0,Ypos=0;
uint8_t buttons; 
int8_t x; 
int8_t y; 
int8_t z;

/*****************************************************************************/
/*Function: OnMouseEvent()                                                   */
/*          This function is called whenever there is change in mouse data   */
/*          It copies the values of x,y and buttons from the device into     */
/*          variables that can be accessed by the main logic to move the     */
/*          bubble on the LCD                                                */
/*Inputs:   The x,y and button values from the Mouse.                        */
/*Outputs:  None.                                                            */
/*****************************************************************************/
void onMouseEvent(uint8_t buttons, int8_t x, int8_t y, int8_t z) {
    pc.printf("Mouse values: x= %d, y= %d\r\n",x,y);
    Xpos = x;
    Ypos = y;
    button = buttons;
}
/*****************************************************************************/

/*****************************************************************************/
/*This thread is the mouse_task thread which will check for the USB Device   */
/*connectivity. If the device is not connected it will issue an error message*/
/*Once the device is connected, this thread will attach the mouse event      */
/*thread.                                                                    */
/*****************************************************************************/
void mouse_task(void const *) {
    
    USBHostMouse mouse;
    
    while(1) {
        
        // try to connect a USB mouse
        while(!mouse.connect()){
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Connect the USB Mouse\n");
            Thread::wait(500);
        }
    
        // when connected, attach handler called on mouse event
        mouse.attachEvent(onMouseEvent);
        
        // wait until the mouse is disconnected
        while(mouse.connected()){
            lcd.cls();
            connect = 1;
            lcd.fillcircle(Xpos,Ypos, 2, 1); 
            wait(.05);
            lcd.fillcircle(Xpos,Ypos, 2, 1); 
            Thread::wait(100);
        }
         connect= 0;
    }
}
/*****************************************************************************/

/*****************************************************************************/
/*This is the main thread. This will do nothing but initiate the mouse task  */
/*thread and then wait forever in the loop                                   */
/*****************************************************************************/ 
int main() {
    Thread mouseTask(mouse_task, NULL, osPriorityNormal, 256 * 4);
    while(1) {
        Thread::wait(osWaitForever);
    }
}
/*****************************************************************************/
