/*****************************************************************************/
/*Function: This program is used to emulate a USB Mouse. The mouse position  */
/*          can be changed by the potentiometers. The output values of x and */
/*          y are modified to move the bubble on the LCD on another MBED     */
/*          acting as USB Host. The program for MBED USB Host can be found at*/
/*          http://mbed.org/users/bhakti08/code/USB_Project_Host/            */
/*Author:   Bhakti Kulkarni                                                  */
/*Date:     03/27/2014                                                       */
/*****************************************************************************/
#include <mbed.h>
#include <USBMouse.h>
#include "DebouncedIn.h"
#include "C12832_lcd.h"
#include "DebouncedInterrupt.h"

#define RANGE 0.02
#define INTERRUPT
#define X_MAX 120
#define Y_MAX 28
#define x_move 7
#define y_move 3

Serial pc(USBTX,USBRX);

DebouncedIn right_click(p13);      //Button enulating right click
DebouncedIn left_click(p16);       //Button emulating left click
DebouncedIn wheel(p14);            //Button emulating the wheel button
C12832_LCD lcd;
AnalogIn X_in(p20);               //Analog input to move bubble in x position
AnalogIn Y_in(p19);               //Analog input to move bubble in y position
 
USBMouse  Mouse;

int Xpos = 0;
int Ypos = 0;

/*****************************************************************************/ 
/*This is the main program. This reads the input from the potentiometers,    */
/*converts them into the values that are required for the lcd display        */
/*and then sends them as the mouse outputs.                                  */
/*****************************************************************************/ 
int main()
{
   float AinX_old = 0;
   float AinX_new;
   float AinY_old = 0;
   float AinY_new;
   while (true){
        if(left_click)
        {
            Mouse.click(MOUSE_LEFT);  //if left click is pressed,
                                      // emulate mouse left
        }
        if (right_click)
        {
            Mouse.click(MOUSE_RIGHT);  //if right click is pressed,
                                      // emulate mouse right
        }
        if (wheel)
        {
            Mouse.click(MOUSE_MIDDLE); //if wheel button is pressed,
                                      // emulate wheel button pressed
        }
        AinX_new = X_in.read();
        //check if the values are between the LCD values
        if (AinX_new >= AinX_old + RANGE){         
            if (Xpos < X_MAX)
                Xpos += x_move;
            else
                Xpos = Xpos;
            AinX_old = AinX_new;        
        }
        else if (AinX_new < AinX_old - RANGE){
            if (Xpos > 0)
                Xpos -= x_move;
            else
                Xpos = Xpos;
            AinX_old = AinX_new;        
        }
        else
            Xpos = Xpos;
            
        AinY_new = Y_in.read();
        if (AinY_new >= AinY_old + RANGE){
            if (Ypos < Y_MAX)
                Ypos += y_move;
            else
                Ypos = Ypos;
            AinY_old = AinY_new;        
        }
        else if (AinY_new < AinY_old - RANGE){
            if (Ypos > 0)
                Ypos -= y_move;
            else
                Ypos = Ypos;
            AinY_old = AinY_new;        
        }
        else
            Ypos = Ypos;
        Mouse.move(Xpos,Ypos);      //Send the values as the mouse output
    }
}

/*****************************************************************************/