#include "mbed.h"
#include "HTTPClient.h"
#include "EthernetInterface.h"

Serial pc(USBTX, USBRX);

EthernetInterface eth;
HTTPClient http;
char message[2000];

DigitalOut myled(LED1);

int main() {
    pc.baud(9600);
    printf("HTTP Client - Build " __DATE__ " - " __TIME__ "\r\n");
    eth.init();
    eth.connect();

    while(1) {
        myled = 1;
        int ret = http.get("http://mbed.org/media/uploads/mbed_official/hello.txt", message, sizeof(message));
        if (!ret) {
            printf("Success - read %d characters.\r\n", strlen(message));
            printf("%s\r\n", message);
        }
        myled = 0;
        wait(10);
    }
    // eth.disconnect();
}
