#include "mbed.h"
#include "rtos.h"
#include "C12832_lcd.h"
#include "DebouncedIn.h"


DigitalOut myled(LED1);
DigitalOut dir_pin(LED4);
DebouncedIn dir_fwd(p15);
DebouncedIn dir_rev(p12);
Serial Wifi_Tx(p9,p10);
Serial Wifi_Rx(p28,p27);
Serial pc(USBTX,USBRX);
C12832_LCD lcd;

bool dir;

void Serial_Tx(void const *args) {
    while (1){
        while (pc.readable())
        {
            Wifi_Tx.putc(pc.getc());
        }
        Thread::wait(1000);
    }
}

void Serial_Rx(void const *) {
    char c;
    while (1) {
        while (Wifi_Rx.readable())
        {
            c = Wifi_Rx.getc();
            lcd.printf("%c",c);
            if (c == 'F')
                dir = 1;
            else if (c == 'R')
                dir = 0;
        }
        Thread::wait (10);
    }
}

void dir_control(void const *) {
    while (1) {
        if ((dir_fwd || dir) && !dir_rev) {
            dir_pin = 1;
            dir = 1;
        }
        else if (dir_rev || !dir) { 
            dir_pin = 0;
            dir = 0;
        }
        Thread::wait(10);
    }
    
}
int main() {
    Thread serial_tx(Serial_Tx);
    Thread serial_rx(Serial_Rx);
    Thread Direction_Control(dir_control);
    while(1) {
        myled = !myled;
        Thread::wait(500);
    }
}
