#include "mbed.h"
#include "EthernetInterface.h"

#define XI_FEED_ID 1344466483 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "mgjx3VwlsvsMBhekqcASRLnzMPHi9Aw2gZCZCzyH0vQkefn3" // set Xively API key (double-quoted string)

#include "app_board_io.h"

#include "xively.h"
#include "xi_err.h"

#include "MMA7660.h"
#include "LM75B.h"
#include "C12832_lcd.h"
#define ECHO_SERVER_PORT   7
#include <string.h>
 
#define FWD 3
#define REV 4
#define LEFT 1
#define RIGHT 2
#define STOP 0
#define STRAIGHT_WHEEL 5
#define servo_1 6
#define servo_2 7

MMA7660 axl(p28, p27);
//LM75B tmp(p28, p27);
AnalogIn tmp(p19);
C12832_LCD lcd;
DigitalOut cL(LED1);
Serial pc(USBTX,USBRX);
BusOut motor(p5,p6,p7);
#include "logo.h"

int main() {
    cL = 1;
    /*lcd_print_xively_logo();*/
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("IP Address is %s\n", eth.getIPAddress());
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    while (true) {
        pc.printf("\nWait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 150000); // Timeout after (1.5)s
        
        pc.printf("Connection from: %s\n", client.get_address());
        char buffer[256];
            motor = STOP;
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) continue;
            buffer[n] = 0;
            pc.printf("String is : %s\r\n",buffer);
 
            client.send_all(buffer, n);
            if (!(strcmp (buffer, "w")))
                motor = FWD;
            else if (!(strcmp(buffer,"x")))
                motor = REV;
            else if (!(strcmp(buffer,"z")))
                motor = STRAIGHT_WHEEL;
            else if (!(strcmp(buffer,"d")))
                motor = RIGHT;
            else if (!(strcmp(buffer,"a")))
                motor = LEFT;
            else if (!(strcmp(buffer,"s")))
                motor = STOP;
            else if (!(strcmp(buffer,"o")))
                motor = servo_1;
            else if (!(strcmp(buffer,"p")))
                motor = servo_2;
              
    pc.printf("Received:%s", buffer);
    
    xi_feed_t feed;
        memset( &feed, NULL, sizeof( xi_feed_t ) );
    
        feed.feed_id = XI_FEED_ID;
        feed.datastream_count = 4;
    
        feed.datastreams[0].datapoint_count = 1;
        xi_datastream_t* temperature_datastream = &feed.datastreams[0];
        strcpy( temperature_datastream->datastream_id, "Temperature" );
        xi_datapoint_t* current_temperature = &temperature_datastream->datapoints[0];
        
        feed.datastreams[1].datapoint_count = 1;
        xi_datastream_t* x_axis_datastream = &feed.datastreams[1];
        strcpy( x_axis_datastream->datastream_id, "X_axis" );
        xi_datapoint_t* accel_x = &x_axis_datastream->datapoints[0];
        
        feed.datastreams[2].datapoint_count = 1;
        xi_datastream_t* y_axis_datastream = &feed.datastreams[2];
        strcpy( y_axis_datastream->datastream_id, "Y_axis" );
        xi_datapoint_t* accel_y = &y_axis_datastream->datapoints[0];
        
        feed.datastreams[3].datapoint_count = 1;
        xi_datastream_t* z_axis_datastream = &feed.datastreams[3];
        strcpy( z_axis_datastream->datastream_id, "Z_axis" );
        xi_datapoint_t* accel_z = &z_axis_datastream->datapoints[0];
        
        xi_context_t* xi_context
            = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );
        if( xi_context == NULL )
        {
            pc.printf("Error in Xi_Context\r\n");
            exit (0);
        }
 
        pc.printf("In xively thread\r\n");
        xi_set_value_f32( current_temperature, tmp.read() ); 
        xi_set_value_f32( accel_x ,axl.x() );
        xi_set_value_f32( accel_y ,axl.y() );
        xi_set_value_f32( accel_z ,axl.z() );
        pc.printf("Value set\r\n");
        xi_feed_update( xi_context, &feed );
        pc.printf("Update\r\n");
     //client.close();
        
 }
   
}