//This Program is used to turn the LED ON/OFF via telent (Wifly connected)
#include "mbed.h"
#include "WiflyInterface.h"
#include <string.h>
#include "LM75B.h"
#include "MMA7660.h"
#include "rtos.h"

#define XI_FEED_ID 1344466483 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "mgjx3VwlsvsMBhekqcASRLnzMPHi9Aw2gZCZCzyH0vQkefn3" // set Xively API key (double-quoted string)

#include "xively.h"
#include "xi_err.h"

#include "C12832_lcd.h"


LM75B temp(p28,p27);
MMA7660 axl(p28,p27);
Serial pc(USBTX,USBRX);
C12832_LCD lcd;

/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
//apps board
WiflyInterface wifly(p9, p10, p30, p29, "MY_WIFI", "", NONE);



int main() {
    
    wifly.init(); //Use DHCP
    pc.printf("1\r\n");
    while (!wifly.connect());
    pc.printf("IP Address is %s\n\r", wifly.getIPAddress());

    
    xi_feed_t feed;
        memset( &feed, NULL, sizeof( xi_feed_t ) );
    
        feed.feed_id = XI_FEED_ID;
        feed.datastream_count = 4;
    
        feed.datastreams[0].datapoint_count = 1;
        xi_datastream_t* temperature_datastream = &feed.datastreams[0];
        strcpy( temperature_datastream->datastream_id, "Temperature" );
        xi_datapoint_t* current_temperature = &temperature_datastream->datapoints[0];
        
        feed.datastreams[1].datapoint_count = 1;
        xi_datastream_t* x_axis_datastream = &feed.datastreams[1];
        strcpy( x_axis_datastream->datastream_id, "X_axis" );
        xi_datapoint_t* accel_x = &x_axis_datastream->datapoints[0];
        
        feed.datastreams[2].datapoint_count = 1;
        xi_datastream_t* y_axis_datastream = &feed.datastreams[2];
        strcpy( y_axis_datastream->datastream_id, "Y_axis" );
        xi_datapoint_t* accel_y = &y_axis_datastream->datapoints[0];
        
        feed.datastreams[3].datapoint_count = 1;
        xi_datastream_t* z_axis_datastream = &feed.datastreams[3];
        strcpy( z_axis_datastream->datastream_id, "Z_axis" );
        xi_datapoint_t* accel_z = &z_axis_datastream->datapoints[0];
        
        xi_context_t* xi_context
            = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );
        if( xi_context == NULL )
        {
            pc.printf("Error in Xi_Context\r\n");
            exit (0);
        }
 
    while (true) {   
        pc.printf("In xively thread\r\n");
        xi_set_value_f32( current_temperature, temp.read() ); 
        xi_set_value_f32( accel_x ,axl.x() );
        xi_set_value_f32( accel_y ,axl.y() );
        xi_set_value_f32( accel_z ,axl.z() );
        pc.printf("Value set\r\n");
        xi_feed_update( xi_context, &feed );
        pc.printf("Update\r\n");
        wait(10);
    }
}