#include "mbed.h"
#include "LM75B.h"
#include "C12832_lcd.h"
#include "rtos.h"
#include "DebouncedIn.h"
#include "DebouncedInterrupt.h"
#include "Serial.h"

//Serial pc(USBTX, USBRX);

#define OPEN 1
#define CLOSE 0
#define ON 1
#define OFF 0
#define INTERRUPT

DebouncedInterrupt increase_time(p13);
DebouncedInterrupt decrease_time(p16);
DebouncedInterrupt start (p12);
DebouncedInterrupt stop(p15);
DebouncedInterrupt door_status(p14);
DigitalOut door_signal(LED4);
//BusOut cook(LED4,LED3,LED2,LED1);

LM75B in_temp(p28,p27);
C12832_LCD lcd;
DigitalOut cook_progress(LED1);
DigitalOut door_Signal(LED4);          //This LED will be 1 if door is open
DigitalOut done_cooking(LED2);
PwmOut speaker(p26);
Timer ellapsed_cook_timer;

int requested_cook_time = 120;
//float inside_temp;                     //Initial value of inside temp is room temperature
bool door_position = OPEN;                      //keep track if door is closed or open door_status = 0: close,1:open
bool cook_status = OFF;
bool speaker_signal;
float ellapsed_cook_time = 0;                                       //Cooking should be stopped if door open


void open_door();
void time_up();
void time_down();
void LED_blink (void const *args);
void sound_speaker (void const *args);
void start_cooking ();
void stop_cooking ();
void update_lcd(void const *args);
void check_ellapsed_cook_time (void const *args);

Ticker LED_Blink_timer;                                 
                                       
                                       
void open_door()
{
      door_position = !door_position;
      {
          if (door_position == OPEN)
          {
              door_Signal = 1;
          }
          else
          {
              door_Signal = 0;
          }
      }
}

void time_up()
{

    if (requested_cook_time < 180)
        requested_cook_time = requested_cook_time + 60;
    else
        requested_cook_time = 180;
}

void time_down()
{
    if (requested_cook_time > 0)
        requested_cook_time = requested_cook_time - 60;
    else
        requested_cook_time = 0;
}

void LED_blink ()
{
    cook_progress= !cook_progress;
}

void start_cooking ()
{
    if (door_position == CLOSE)
    {
        speaker_signal = 1;
        ellapsed_cook_timer.start();
        LED_Blink_timer.attach(&LED_blink,0.250);
    }
}

void stop_cooking ()
{
    ellapsed_cook_timer.stop();
    cook_status = OFF;
    LED_Blink_timer.detach();
    cook_progress = 0;
    speaker_signal = 0;
}

void start_speaker()
{
    speaker.period(1.0/5000);
    while(door_position != OPEN && speaker_signal == 1){
        speaker = 0.5;
        wait(0.1);
        speaker = 0.0;
        wait(0.1);
    }
    speaker_signal = 0;
}

void update_lcd(void const *args)
{
     lcd.cls();
      while(true)
      {
          lcd.locate(0,0);
          lcd.printf("Ellapsed time is %0.2f",ellapsed_cook_timer.read()/60);
          lcd.locate(0,10);
          lcd.printf("Set time is %d",requested_cook_time/60);
          Thread::wait (1000);
      }
}


void check_ellapsed_cook_time (void const *args)
{
    while (true)
    {
        if (ellapsed_cook_timer.read()/60 >= requested_cook_time/60 )//&& cook_status != OFF)
        {
            ellapsed_cook_timer.stop();
            ellapsed_cook_timer.reset();
            cook_status = OFF;
            LED_Blink_timer.detach();
            start_speaker();
         }
        Thread::wait(10);
    }
}


int main()
{
    //printf("\nIn main");
    Thread lcd_display(update_lcd,NULL,  osPriorityAboveNormal);
    Thread track_ellapsed_cook_time(check_ellapsed_cook_time,NULL,osPriorityHigh);
    increase_time.attach(&time_up);
    decrease_time.attach(&time_down);
    start.attach(&start_cooking);
    stop.attach(&stop_cooking);
    door_status.attach(&open_door);
    door_Signal = door_position;
    
    
    while (true)
    {
        if(door_Signal == OPEN )//|| stop == 1)
           stop_cooking();
        Thread::wait(400);
    }
}