/*******************************************************/
/*              IMPLEMENT THE THERMOSTAT               */
/*System turned ON/OFF using joystick or Accelerometer */
/*Temperature Set using Joystick                       */
/*System Status and heater state shown on LED          */
/*LCD displays: Time.                                  */
/*              If system is ON current and set low    */
/*                 and High Temperature                */
/*              Heater/Cooler ON                       */
/*              If system is OFF SYSTEM OFF            */
/*The timing, current temperature, accelerometer reading*/
/*are sent periodically to websockets.org/bhakti       */
/*The duration after which the information is sent is  */
/*defined by macro SECONDS which is currently set to 10*/
/*******************************************************/

#include "mbed.h"
#include "C12832_lcd.h"
#include "LM75B.h"
#include "DebouncedIn.h"
#include "MMA7660.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "SimpleSMTPClient.h"
#include "Small_6.h"
#include "Websocket.h"

#define hys 3
#define HEATER 0
#define COOLER 1
#define No_HEAT_COOL 2
#define SEND 1
#define DO_NOT_SEND 0
#define SECONDS 10

DebouncedIn reset(p14);
C12832_LCD lcd;
LM75B current(p28,p27);
MMA7660 MMA(p28, p27);
Serial pc(USBTX,USBRX);
AnalogIn max_temp(p19);
AnalogIn min_temp(p20);

//System ON/OFF
BusIn heat_on (p16,p13); 
                                      
//System ON/OFF LED
DigitalOut thermostat (LED1);

//Heater/Cooler ON/OFF LED. This can be furthur connected to the relay                                  
DigitalOut heater (LED2);  
DigitalOut cooler (LED3);

Ticker check_move;                                    
Ticker Send_info;

bool no_move;             //This variable is set if no movement is detected
float acc_x = MMA.x();
float acc_y = MMA.y();
float acc_z = MMA.z();
float acc_x_old,acc_y_old,acc_z_old;
int heat_cool;     //1: Heater ON , 0:Cooler ON , 2: Heater and Cooler OFF
bool send_info;    //This variable is used to define when the information is
                   //to be sent to the web.

/****************************************************************************/
/*Function name: check: This function is used to detect motion around the   */
/*thermostat.It sets the variable no move if the previous and current       */
/*value of the accelerometer value is same. Accelerometer value unchanged   */
/*indicates that there is no motion around the thermostat                   */
/****************************************************************************/
void check()
{
    acc_x_old = acc_x;
    acc_y_old = acc_y;
    acc_z_old = acc_z;
    acc_x = MMA.x();
    acc_y = MMA.y();
    acc_z = MMA.z();
    if (acc_x_old == acc_x && acc_y_old == acc_y && acc_z_old == acc_z)
    {
        no_move = 1;
    }
    else
        no_move = 0;
    
}
/******************************************************************************/

/******************************************************************************/
/*Function name: send_ws()                                                    */
/*This function is used to set a boolean variable to SEND so that the         */
/*information can be sent over the web. The variable is set to SEND after no. */
/*of seconds defined by SECONDS(currently 10sec)                              */
/******************************************************************************/
void send_ws()
{
    send_info = SEND;
}

/*******************************************************************************/

int main()
{
    int ret_msg,ret_msg2,ret_curr_time,eth_ret,ws_ret;
    EthernetInterface eth;
    lcd.cls();
    pc.printf("\n\n/* SimpleMTPClient library demonstration \n");

    pc.printf("Setting up ...\n");
    eth.init();
    eth_ret = eth.connect();
    if (eth_ret != 0)
    {
        lcd.cls();
        lcd.printf("Ethernet not connected");
        return -1;
    }
    pc.printf("Connected OK\n");

    // IP Address 
    pc.printf("IP Address is %s\n", eth.getIPAddress());
    lcd.locate(0,1);
    lcd.printf("%s", eth.getIPAddress());
    wait(2);
   
    
    NTPClient ntp;
    ntp.setTime("time.nist.gov");                                     
    lcd.cls(); 
    
    Websocket ws("ws://sockets.mbed.org:443/ws/bhakti/rw");
    ws_ret = ws.connect();
    if (!ws_ret)
    {
        lcd.cls();
        lcd.printf("Nor connected to URL");
        return -1;
    }
    
        /*Messages to be sent over the web*/
    char msg[100];
    char msg2[100];
    char curr_time[100];
                                                  
    float min_set;
    float max_set; 
    
    //This variable is used to check if the system is ON or OFF                                            
    bool status=0;
        
    time_t ctTime;                         
    lcd.cls();                 
    check_move.attach(&check,120.0);
    Send_info.attach(&send_ws,SECONDS);
    while (1) {
        sprintf(msg,"Temperature is %0.2f",current.read());
        sprintf(msg2,"Accelerometer readings are X= %0.2f,Y= %0.2f, Z= %0.2f",MMA.x(),MMA.y(),MMA.z());
              sprintf(curr_time,"Time: %s",ctime(&ctTime));
        if (send_info == SEND) {
            ret_msg2 = ws.send(msg2);
            ret_msg = ws.send(msg);
            ret_curr_time=ws.send(curr_time);
            if (ret_msg == -1 || ret_msg2 == -1 || ret_curr_time == -1)
            {
                lcd.cls();
                lcd.printf("One of the messages not sent");
            }
            send_info = DO_NOT_SEND;
        }
        min_set = min_temp.read() * 50;   //scale the pot value from 0 to 1 -> 0 to 50
        max_set = max_temp.read() * 50;
        ctTime = time(NULL) - 25200;      //Adjust time as per local time
        lcd.set_font((unsigned char*) Small_6);  //set LCD font
        lcd.locate(1,1);
        lcd.printf("%s",ctime(&ctTime));                     
        lcd.locate(1,8);
          
        /*If system is ON print current and set temperature*/
        /*Else print LCD OFF on LCD*/
                                           
        if (status) {                                          
            lcd.printf("Curr:%.2f",current.read());
            lcd.locate(1,16);
            lcd.printf("MAX:%0.2f, MIN:%0.2f",max_set,min_set);
            lcd.locate(1,24);
            switch (heat_cool) {
                case HEATER : lcd.printf("Heater ON     ");
                              break;
                case COOLER : lcd.printf("Cooler ON     ");
                              break;
                case No_HEAT_COOL : lcd.printf("Heat/Cool OFF");
                              break;
            }
            
        } else {                                               
            lcd.locate(1,10);
            lcd.printf("System OFF");
            wait (0.1);
        }
        
        /*If system is turned ON: Joystick is pushed towards edge of LCD
          OR movement is detected
          Turn System ON LED on: LED1 and Set the status variable to 1
          Else if system is turned OFF by user turn OFF the system status LED
          and the LED that is connected to the relay*/
          
        if (heat_on == 0x2 || !no_move) 
        {
            thermostat = 1;                                    
            status = 1;                                        
        } else if (heat_on == 0x1 || no_move) {          
            lcd.cls();                                        
            thermostat = 0;                                    
            heater = 0;                                       
            status = 0;                                       
        }
        
        //Comparison logic and turn Heater/Cooler ON/OFF
        if ((min_set > (current.read()+ hys)) && thermostat == 1) {
            heater =  1;
            cooler = 0;
            status = 1;
            heat_cool = HEATER;
        }
        else if ((max_set < (current.read()-hys)) && thermostat == 1) {
            cooler = 1;
            heater = 0;
            status = 1;
            heat_cool = COOLER;    
        }
        else if (!thermostat) {
            heater = 0;
            cooler = 0;
            status = 0;
        }
        else {
            heater = 0;
            cooler = 0;
            status = 1;
            heat_cool = No_HEAT_COOL;
        }
            
     }
}
