//This Program is used to turn the LED ON/OFF via telent (Wifly connected)
#include "mbed.h"
#include "WiflyInterface.h"
#include <string.h>
#include "LM75B.h"
#include "MMA7660.h"

#define XI_FEED_ID 209829319 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "T0izYrB6TZVkmhhEWpzs5L7F5wqpJixxc6MtenkLDg3BLMIu" // set Xively API key (double-quoted string)

#include "xively.h"
#include "xi_err.h"

#include "C12832_lcd.h"

#define SEC 1000


#define ECHO_SERVER_PORT   7


PwmOut servo(p22);
DigitalOut dir(LED1);
//LM75B temp(p28,p27);
AnalogIn temp(p19);
MMA7660 axl(p28,p27);
Serial pc(USBTX,USBRX);
C12832_LCD lcd;

#define FWD 1
#define REV 0


/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
//apps board
WiflyInterface wifly(p9, p10, p30, p29, "MY_WIFI", "", NONE);

//pololu
//WiflyInterface wifly(p28, p27, p26, NC, "iotlab", "42F67YxLX4AawRdcj", WPA);

int main() {
    
   // char    recv[128];
    
    wifly.init(); //Use DHCP
    pc.printf("1\r\n");
    while (!wifly.connect());
    pc.printf("IP Address is %s\n\r", wifly.getIPAddress());

    xi_feed_t feed;
        memset( &feed, NULL, sizeof( xi_feed_t ) );
    
        feed.feed_id = XI_FEED_ID;
        feed.datastream_count = 1;
    
        feed.datastreams[0].datapoint_count = 1;
        xi_datastream_t* temperature_datastream = &feed.datastreams[0];
        strcpy( temperature_datastream->datastream_id, "Temperature" );
        xi_datapoint_t* current_temperature = &temperature_datastream->datapoints[0];
        
        xi_context_t* xi_context
            = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );
        if( xi_context == NULL )
        {
            pc.printf("Error in Xi_Context\r\n");
            exit (0);
        }
 
        
       while (true) {
        xi_set_value_f32( current_temperature, temp.read() ); 
        xi_feed_update( xi_context, &feed );
      wait(10.0);
    }
}