//This Program is used to turn the LED ON/OFF via telent (Wifly connected)
#include "mbed.h"
#include "WiflyInterface.h"
#include <string.h>
 
#define ECHO_SERVER_PORT   7
#define FWD 8
#define REV 4
#define LEFT 3
#define RIGHT 1
#define STOP 2
#define STRAIGHT_WHEEL 7
 
 
PwmOut servo(p22);
DigitalOut dir(LED1);
BusOut motor(p5,p6,p7,p8);
 
//#define FWD 1
//#define REV 0
 
 
/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
//apps board
WiflyInterface wifly(p9, p10, p30, p29, "MY_WIFI", "", NONE);
 
//pololu
//WiflyInterface wifly(p28, p27, p26, NC, "iotlab", "42F67YxLX4AawRdcj", WPA);
 
int main() {
    
    wifly.init(); //Use DHCP
    printf("1\r\n");
    while (!wifly.connect());
    printf("IP Address is %s\n\r", wifly.getIPAddress());
    
   TCPSocketServer server;
    
    server.bind(ECHO_SERVER_PORT);
    server.listen();
 
    printf("\nWait for new connection...\n");
    TCPSocketConnection client;
    server.accept(client);
 
    char buffer[256];
    servo.period_us(50);
    motor = STOP;
    while (true) {
        //if (client.available()){
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) continue;
            buffer[n] = 0;
            printf("String is : %s\r\n",buffer);
 
            client.send_all(buffer, n);
            if (!(strcmp (buffer, "w")))
                motor = FWD;
            else if (!(strcmp(buffer,"x")))
                motor = REV;
            else if (!(strcmp(buffer,"z")))
                motor = STRAIGHT_WHEEL;
            else if (!(strcmp(buffer,"d")))
                motor = RIGHT;
            else if (!(strcmp(buffer,"a")))
                motor = LEFT;
            else if (!(strcmp(buffer,"s")))
                motor = STOP;
        //}
        servo.pulsewidth_us(10);
        wait_us(1);
    }
}
