/****************************************************************************************/
/*                                 IO DEVICES ASSIGNMENT 6                              */
/*This program uses the PWM output to generate a "HAPPY BIRTHDAY" Tone on the speaker   */
/****************************************************************************************/

#include "mbed.h"

//              ms      
#define A4      440        
#define B4b     446         
#define C4      261
#define C4_1    130 
#define C5      523      
#define D4      293   
#define D4b     277               
#define E4      329          
#define F4      349           
#define G4      392  

PwmOut buzzer(p26);


float notes[] = {C4_1,C4,D4,C4,F4,E4,C4_1,C4,D4,C4,G4,F4,C4_1,C4,C5,A4,F4,E4,D4,B4b,B4b,A4,F4,G4,F4};


float interval[] = {4, 4, 8, 8, 8, 10, 4, 4, 8, 8, 8, 10, 4, 4, 8, 8, 8, 8, 8, 4, 4, 8, 8, 8, 12};                            
                             
int main() {
    while (1) {
    for (int i=0;i<=24;i++) {
        buzzer.period((1/notes[i]));                        // set PWM period
        buzzer=0.5;                                         // set duty cycle
        wait(0.8*interval[i]/10);                           // hold for beat period
        }
    buzzer = 0;
    wait(5);
    }
}


/****************************************************************************************/
/*                                        TESTING                                       */
/****************************************************************************************/

/*1. Power up the mbed, load the program and press the reset button. The tone should play*/
/*   as long as the mbed is powered up.                                              PASS*/
/*****************************************************************************************/