
/** A replacement for InterruptIn that debounces the interrupt
 *  Anil Kandangath
 *
 * @code
 *
 * #include "DebouncedInterrupt.h"
 *
 * DebouncedInterrupt up_button(p15);
 * 
 * void onUp()
 * {
 *    // Do Something
 * }
 * 
 * int main()
 * {
 *     up_button.attach(&onUp, 100);
 *     while(1) {
 *         ...
 *     }
 * }
 * @endcode
 */
 
#ifndef DEBOUNCED_INTERRUPT_H
#define DEBOUNCED_INTERRUPT_H

#include <stdint.h>
#include "mbed.h"

class DebouncedInterrupt {
private:
    unsigned int _debounce_us;
    InterruptIn *_in;
    DigitalIn *_din;
    
    // Diagnostics
    volatile unsigned int _bounce_count;
    volatile unsigned int _last_bounce_count;
    
    void (*fCallback)(void);
    void _onInterrupt(void);
    void _callback(void);
public:
    DebouncedInterrupt(PinName pin);
    ~DebouncedInterrupt();
    
    // Start monitoring the interupt and attach a callback
    void attach(void (*fptr)(void), const uint32_t& debounce_ms=10);
   
    // Stop monitoring the interrupt
    void reset();
    
    
    /*
    * Get number of bounces 
    * @return: bounce count
    */
    unsigned int get_bounce();
};
#endif