/**
* DebouncedInterrupt.cpp
**/
#include "DebouncedInterrupt.h"

Timeout timeout;

DebouncedInterrupt::DebouncedInterrupt(PinName pin)
{
    _in = new InterruptIn(pin);
    _din = new DigitalIn(pin);
}

DebouncedInterrupt::~DebouncedInterrupt()
{
    delete _in;
    delete _din;
}

void DebouncedInterrupt::attach(void (*fptr)(void), const unsigned int& debounce_ms)
{
    if(fptr) {
        fCallback = fptr;
        _last_bounce_count = _bounce_count = 0;
        _debounce_us = 1000*debounce_ms;
        
        _in->rise(this, &DebouncedInterrupt::_onInterrupt);
        _in->fall(this, &DebouncedInterrupt::_onInterrupt);
    }
}

void DebouncedInterrupt::reset()
{
    timeout.detach();
}

unsigned int DebouncedInterrupt::get_bounce()
{
    return _last_bounce_count;
}

void DebouncedInterrupt::_callback()
{
    _last_bounce_count = _bounce_count;
    _bounce_count = 0;
    if(_din->read()) {
        fCallback();
    }
}

void DebouncedInterrupt::_onInterrupt()
{
    _bounce_count++;
    timeout.attach_us(this, &DebouncedInterrupt::_callback, _debounce_us);
}
