// Brent Hearn
// 03/2011

// shiftbrite fading. Color patterns can eiher be user input or a random number generator can pick out values to use.
// Rate of fading can also be changed.
// Note: Watch for current spikes when transitioning between colors with multiple Shiftbrites in a chain.
//       Setting the Current Control register to lower values (eg 31 instead of 127) can mediate this effect at the cost of brightness.

// Color fading example code from:  http://www.arduino.cc/cgi-bin/yabb2/YaBB.pl?num=1253503406
// Shift register code from:        http://mbed.org/users/ChriX/notebook/shift-register-function/
// Shiftbrite Arduino code from:    http://macetech.com/blog/node/54

#include "mbed.h"

DigitalOut datapin(p30);
DigitalOut latchpin(p29);
DigitalOut enablepin(p28);
DigitalOut clockpin(p27);

volatile int colorSelected[3];
bool fadeComplete = true;

unsigned long SB_CommandPacket;
int SB_CommandMode;
int SB_ColorCommand[3];
int No_of_shiftbrites = 4;

// Current Control between 0 and 127
int Cur = 31;

void shiftOut(DigitalOut data, DigitalOut clk, int sodata) {

    int i;

    for (i = 7; i >= 0; i--) {

        clk = 0;

        if(sodata & (1 << i)){
            data = 1;
        } else {
            data = 0;
        }

        clk = 1;
        data = 0;
    }

return;

}


void SB_SendPacket() {

    for (int y = No_of_shiftbrites-1; y >= 0; y--) {
        SB_CommandPacket = SB_CommandMode & 0xB11;
        SB_CommandPacket = (SB_CommandPacket << 10) | (SB_ColorCommand[0] & 1023);
        SB_CommandPacket = (SB_CommandPacket << 10) | (SB_ColorCommand[1] & 1023);
        SB_CommandPacket = (SB_CommandPacket << 10) | (SB_ColorCommand[2] & 1023);
    
        shiftOut(datapin, clockpin, SB_CommandPacket >> 24);
        shiftOut(datapin, clockpin, SB_CommandPacket >> 16);
        shiftOut(datapin, clockpin, SB_CommandPacket >> 8);
        shiftOut(datapin, clockpin, SB_CommandPacket);
    
    
        wait_ms(1);
        latchpin = 1;
        wait_ms(1);
        latchpin = 0;
   }
   
   return;

}

void Current_Control() {

    int Comm = 0xB01;
    int Cont1 = Cur;
    int Cont2 = Cur;
    int Cont3 = Cur;
    unsigned long CommandPacket;
    
    for (int y = No_of_shiftbrites-1; y >= 0; y--) {
        CommandPacket = Comm & 0xB11;
        CommandPacket = (CommandPacket << 10) | (Cont1 & 1023);
        CommandPacket = (CommandPacket << 10) | (Cont2 & 1023);
        CommandPacket = (CommandPacket << 10) | (Cont3 & 1023);
    
        shiftOut(datapin, clockpin, CommandPacket >> 24);
        shiftOut(datapin, clockpin, CommandPacket >> 16);
        shiftOut(datapin, clockpin, CommandPacket >> 8);
        shiftOut(datapin, clockpin, CommandPacket);
    
    
        wait_ms(1);
        latchpin = 1;
        wait_ms(1);
        latchpin = 0;
   }
   
   return;

}

void colorSelect()
{
  for (int i = 0; i <= 2; i++)
  {
    colorSelected[i] = (rand() % 1023);
    //if (colorSelected[i] > 1023) colorSelected[i] = 1023;
  }
  
  return;
}

void fadeall(int rate, int fromred, int fromgreen, int fromblue, int tored, int togreen, int toblue) {

    for (int i = 0; i < 33; i++) {
        SB_ColorCommand[0] = (fromblue * (32 - i) + toblue * i) / 32;
        SB_ColorCommand[1] = (fromred * (32 - i) + tored * i) / 32;
        SB_ColorCommand[2] = (fromgreen * (32 - i) + togreen * i) / 32;               
    
        SB_CommandMode = 0xB00;
        SB_SendPacket();
    
    
        Current_Control();
        wait_ms(rate);
    }

    return;

}

int main() {
    // Initialise previous color to start at Red.
    int Prev_color[3] = {1023, 0, 0};
    
    Current_Control();
    
    while(1) {
          
        // Fade using random color generation                        
        colorSelect();
        fadeall(50, Prev_color[0], Prev_color[1], Prev_color[2], colorSelected[0], colorSelected[1], colorSelected[2]);
        for (int i = 0; i < 3; i++) Prev_color[i] = colorSelected[i];
        
        // Fade using specified pattern
        // eg. Red to Blue to Yellow back to Red as below
        //fadeall(50, 1023, 0, 0, 0, 0, 1023);
        //fadeall(50, 0, 0, 1023, 1023, 1023, 0);
        //fadeall(50, 1023, 1023, 0, 1023, 0, 0);

    }
}
