// Brent Hearn
// 03/2011

// A simple program to cycle a chain of shiftbrites through RGB,MCY,W using mbed.

// Shift register code from:        http://mbed.org/users/ChriX/notebook/shift-register-function/
// Shiftbrite Arduino code from:    http://macetech.com/blog/node/54

// Revision:
// v1.0 - 17/03/2011:
// v1.1 - 20/03/2011:   Separated Current Control from Color Data.
//                      Current_Control() is now a function on it's own which can be put after each color change.
//                      Added Global variable Cur which sets the current control register without having to hunt through the program.

#include "mbed.h"

DigitalOut datapin(p30);
DigitalOut latchpin(p29);
DigitalOut enablepin(p28);
DigitalOut clockpin(p27);

unsigned long SB_CommandPacket;
int SB_CommandMode;
int SB_BlueCommand;
int SB_RedCommand;
int SB_GreenCommand;
int No_of_shiftbrites = 4;

// Set between 0 and 127
int Cur = 31;

void shiftOut(DigitalOut data, DigitalOut clk, int sodata) {

    int i;

    for (i = 7; i >= 0; i--) {

        clk = 0;

        if(sodata & (1 << i)){
            data = 1;
        } else {
            data = 0;
        }

        clk = 1;
        data = 0;
    }

return;

}


void SB_SendPacket() {

    for (int y = No_of_shiftbrites-1; y >= 0; y--) {
        SB_CommandPacket = SB_CommandMode & 0xB11;
        SB_CommandPacket = (SB_CommandPacket << 10) | (SB_BlueCommand & 1023);
        SB_CommandPacket = (SB_CommandPacket << 10) | (SB_RedCommand & 1023);
        SB_CommandPacket = (SB_CommandPacket << 10) | (SB_GreenCommand & 1023);
    
        shiftOut(datapin, clockpin, SB_CommandPacket >> 24);
        shiftOut(datapin, clockpin, SB_CommandPacket >> 16);
        shiftOut(datapin, clockpin, SB_CommandPacket >> 8);
        shiftOut(datapin, clockpin, SB_CommandPacket);
    
    
        wait_ms(1);
        latchpin = 1;
        wait_ms(1);
        latchpin = 0;
    }
    
    return;

}

void Current_Control() {

    int Comm = 0xB01;
    int Cont1 = Cur;
    int Cont2 = Cur;
    int Cont3 = Cur;
    unsigned long CommandPacket;
    
    for (int y = No_of_shiftbrites-1; y >= 0; y--) {
        CommandPacket = Comm & 0xB11;
        CommandPacket = (CommandPacket << 10) | (Cont1 & 1023);
        CommandPacket = (CommandPacket << 10) | (Cont2 & 1023);
        CommandPacket = (CommandPacket << 10) | (Cont3 & 1023);
    
        shiftOut(datapin, clockpin, CommandPacket >> 24);
        shiftOut(datapin, clockpin, CommandPacket >> 16);
        shiftOut(datapin, clockpin, CommandPacket >> 8);
        shiftOut(datapin, clockpin, CommandPacket);
    
    
        wait_ms(1);
        latchpin = 1;
        wait_ms(1);
        latchpin = 0;
   }
   
   return;

}

int main() {
    while(1) {
        Current_Control();
        
        // Red
        SB_CommandMode = 0xB00;
        SB_RedCommand = 1023; // max = 1023
        SB_GreenCommand = 0;
        SB_BlueCommand = 0;
        SB_SendPacket();
        
        wait(3);
        
        Current_Control();
        
        // Green
        SB_CommandMode = 0xB00;
        SB_RedCommand = 0;
        SB_GreenCommand = 1023;
        SB_BlueCommand = 0;
        SB_SendPacket();
        
        wait(3);
        
        Current_Control();
        
        // Blue
        SB_CommandMode = 0xB00;
        SB_RedCommand = 0;
        SB_GreenCommand = 0;
        SB_BlueCommand = 1023;
        SB_SendPacket();
        
        wait(3);
        
        Current_Control();
        
        // Magenta
        SB_CommandMode = 0xB00;
        SB_RedCommand = 1023;
        SB_GreenCommand = 0;
        SB_BlueCommand = 1023;
        SB_SendPacket();
        
        wait(3);
        
        Current_Control();
        
        // Cyan
        SB_CommandMode = 0xB00;
        SB_RedCommand = 0;
        SB_GreenCommand = 1023;
        SB_BlueCommand = 1023;
        SB_SendPacket();
        
        wait(3);
        
        Current_Control();
        
        // Yellow
        SB_CommandMode = 0xB00;
        SB_RedCommand = 1023;
        SB_GreenCommand = 1023;
        SB_BlueCommand = 0;
        SB_SendPacket();
        
        wait(3);
        
        Current_Control();
        
        // White
        SB_CommandMode = 0xB00;
        SB_RedCommand = 1023;
        SB_GreenCommand = 1023;
        SB_BlueCommand = 1023;
        SB_SendPacket();
        
        wait(3);
    }
}
