#include "rtos.h"
#include "mbed.h"
#include <math.h>
#include "LSM9DS0.h"
#include "SongPlayer.h"

SongPlayer mySpeaker(p26);
AnalogIn aIn(p20);
AnalogOut aOut(p18);

DigitalOut left(p21);
DigitalOut right(p22);
DigitalOut up(p23);
DigitalOut down(p24);
DigitalOut center(p25);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// SDO_XM and SDO_G are pulled up, so our addresses are:
#define LSM9DS0_XM_ADDR  0x1D // Would be 0x1E if SDO_XM is LOW
#define LSM9DS0_G_ADDR   0x6B // Would be 0x6A if SDO_G is LOW

// refresh time. set to 500 for part 2 and 50 for part 4
#define REFRESH_TIME_MS 500

// Verify that the pin assignments below match your breadboard
LSM9DS0 imu(p9, p10, LSM9DS0_G_ADDR, LSM9DS0_XM_ADDR);


Serial pc(USBTX, USBRX);
float note[18]= {1568.0,1396.9,1244.5,1244.5,1396.9,1568.0,1568.0,1568.0,1396.9,
                 1244.5,1396.9,1568.0,1396.9,1244.5,1174.7,1244.5,1244.5, 0.0
                };
float duration[18]= {0.48,0.24,0.72,0.48,0.24,0.48,0.24,0.24,0.24,
                     0.24,0.24,0.24,0.24,0.48,0.24,0.48,0.48, 0.0
                    };

void setup()
{
    //pc.baud(115200);

    // Use the begin() function to initialize the LSM9DS0 library.
    // You can either call it with no parameters (the easy way):
    uint16_t status = imu.begin();

    //Make sure communication is working
    pc.printf("LSM9DS0 WHO_AM_I's returned: 0x%X\n", status);
    pc.printf("Should be 0x49D4\n\n");
}

void playInputSig(void const *args) {
    float testVal = aIn;
    float testNote = 1333.3;
    while(1) {
        //aOut.write(0.0);
        testVal = aIn.read();
        mySpeaker.PlaySong(&testNote, &testVal);
        wait(testVal * 10);
    }    
}

void readData() {
    // To read from the device, you must first call the
    // readMag(), readAccel(), and readGyro() functions.
    // When this exits, it'll update the appropriate
    // variables ([mx, my, mz], [ax, ay, az], [gx, gy, gz])
    // with the most current data.
 
    imu.readMag();
    imu.readAccel();
    imu.readGyro();
}

int main() {
    aOut = 0.0;
    Thread t1(playInputSig);

    imu.begin();
    float testVal = 0;
    
    while(1){
        readData();
        if(imu.gx < testVal) {
            left = 0;
            right = 1;
            led1 = 1;
            led2 = 0;
            center = 1; 
        } else if(imu.gx > testVal) {
            left = 1;
            right = 0;
            led1 = 0;
            led2 = 1;
            center = 1;   
        }
        if(imu.gy < testVal) {
            down = 0;
            up = 1;
            led3 = 1;
            led4 = 0;
        } else if(imu.gy > testVal) {
            down = 1;
            up = 0;
            led3 = 0;
            led4 = 1;     
        }
        if((led1 | led2 | led3 | led4) == 0){
            led1 = 1;
            led2 = 1;
            led3 = 1;
            led4 = 1;
            center = 0; 
        }
        
    }

}
