#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include <math.h>

Serial pc(USBTX, USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//digital in for player 1 contorls
DigitalIn up1(p16);
DigitalIn center1(p17);
DigitalIn left1(p15);
DigitalIn down1(p19);
DigitalIn right1(p20);
////
//////digital in for player 2 controls
DigitalIn up2(p22);
DigitalIn center2(p23);
DigitalIn left2(p24);
DigitalIn down2(p25);
DigitalIn right2(p26);
//pwmout for sound
AnalogOut sound_out(p18);
//
////mutex lock for printing to the lcd (only one thread can have the lock at once)
//Mutex p1_mutex;
//Mutex p2_mutex;
//
//the lcd instance to print to
uLCD_4DGL uLCD(p9, p10, p11);

typedef struct {
    int x;
    int y;
    int old_x;
    int old_y;
    int points;
    int size;
    int color;
} player;

player player1 = {5,5,0,0,0,5,0xFFFFFF}; 
player player2 = {120,120,0,0,0,5,0xFF00FF}; 


int getDX(int left, int right){
    if(left == 0)
        return -1;
    else if (right == 0)
        return 1;
    else 
        return 0;
}

int getDY(int up, int down){
    if(up == 0)
        return -1;
    else if (down == 0)
        return 1;
    else 
        return 0;
}


void getP1Info(void const *args){
    while(1){
//        int dx = getDX(left1, right1);
//        int dy = getDY(up1, down1);
//        p1_mutex.lock();
//        player1.x += dx;
//        player1.y += dy;
//        p1_mutex.unlock();
//        
        led1 = !led1;
        Thread::wait(100);
    }
    
}

void getP2Info(void const *args){
    while(1){
 //       int dx = getDX(left2, right2);
//        int dy = getDY(up2, down2);
//        p2_mutex.lock();
//        player2.x += dx;
//        player2.y += dy;
//        p2_mutex.unlock();
//        
        led2 = !led2;
        Thread::wait(100);
        
        
    }
}

void playMusic(double amp){
    sound_out = amp;
}

////the method that displays information to 
//void display2LCD(char x, char y, const char* s){
//    lcd.locate(x,y);
//    lcd.printf("%s\n", s);
//}

char* strAppendInt(const char* s, int i){
    char integer_string[32];
    sprintf(integer_string, "%d", i);

    char* new_s = (char*) malloc(strlen(s) + strlen(integer_string));
    strcpy(new_s, s);
    strcat(new_s, integer_string); // other_string now contains "Integer: 1234"
    
    return new_s;
}

void fixPlayersXY(player* player){
    if(player->x < 2){
        player->x = 3;
    }else if(player->x > 126){
        player->x = 125;
    }
    
    if(player->y < 2){
        player->y = 3;
    }else if(player->y > 126){
        player->y = 125;
    }
}

void update(){
    while(1){
        //p1_mutex.lock();
        
        int dx = getDX(left1, right1);
        int dy = getDY(up1, down1);
        player1.x += dx;
        player1.y += dy;
        fixPlayersXY(&player1);
        uLCD.circle(player1.old_x , player1.old_y , player1.size, 0);
        uLCD.circle(player1.x , player1.y , player1.size, player1.color);
        player1.old_x = player1.x;
        player1.old_y = player1.y;
        int x1 = player1.x;
        int y1 = player1.y;
        
 //       char* s = "\n1:";
//        pc.printf(strAppendInt(strAppendInt(s, x1), y1));
        
        //p1_mutex.unlock();
        
        //p2_mutex.lock();
        int dx2 = getDX(left2, right2);
        int dy2 = getDY(up2, down2);        
        player2.x += dx2;
        player2.y += dy2;
        fixPlayersXY(&player2);
                
        uLCD.circle(player2.old_x , player2.old_y , player2.size, 0);
        uLCD.circle(player2.x , player2.y , player2.size, player2.color);
        player2.old_x = player2.x;
        player2.old_y = player2.y;
        int x2 = player2.x;
        int y2 = player2.y;
        
        //char* s1 = " 2:";
        //pc.printf(strAppendInt(strAppendInt(s1, x2), y2));
        
        //p2_mutex.unlock();
        
        double dist = sqrt((double) ((x2-x1)*(x2-x1) + (y2-y1)*(y2-y1)));
        //char* s2 = " d:";
        //pc.printf(strAppendInt(s2, (int) (dist*100)));
        
        playMusic(dist/1810.0);
        
        //WINNING CONDITION        
        if(dist < (double) player1.size || dist < (double) player2.size){
            while(1){
                playMusic(0.0);
            }
        }

        //uLCD.filled_circle(60, 50, 30, 0xFF00FF);
//        uLCD.triangle(120, 100, 40, 40, 10, 100, 0x0000FF);
//        uLCD.line(0, 0, 80, 60, 0xFF0000);
//        uLCD.filled_rectangle(50, 50, 100, 90, 0x00FF00);
//        uLCD.pixel(60, 60, BLACK);
//        uLCD.read_pixel(120, 70);
//        uLCD.circle(120, 60, 10, BLACK);
//        uLCD.set_font(FONT_7X8);
//        uLCD.text_mode(TRANSPARENT);
//        uLCD.text_bold(ON);
//        uLCD.text_char('B', 9, 8, BLACK);
//        uLCD.text_char('I',10, 8, BLACK);
//        uLCD.text_char('G',11, 8, BLACK);
//        uLCD.text_italic(ON);
//        uLCD.text_string("This is a test of string", 1, 4, FONT_7X8, WHITE);
//        wait(2);
        
        led3 = !led3;
        wait(0.05);
    }
}


//sets up the LCD display
void setup(){
    //set up the lcd
    uLCD.baudrate(3000000);
    uLCD.background_color(0);
    uLCD.cls();
    uLCD.printf("Initializing...");
    uLCD.cls();
    
    pc.baud(9600);
    
    //load the wave file from sd
    //loadWaveFileFromSD();
}


int main() {
    //set up for the threads
    setup();

    //test();

//    Thread t1(getP1Info);
//    Thread t2(getP2Info);
    //one of the threads is just going to be the main method
    update();
}



//        int dur = mySpeaker.getDuration();
//        int note = mySpeaker.getNoteCount();
//        
//        char* s = "Duration:";
//        s = strAppendInt(s, dur);
//        strcat(s, ", Current Note:");
//        s = strAppendInt(s, note); 
//        
//        display2LCD(0, 0, s);
//        
//        Thread::wait(1000);

////appends an integer to a string and returns the pointer to the new string



//
//void test(){
//    uLCD.printf("\nHello uLCD World\n"); //Default Green on black text
//    uLCD.printf("\n  Starting Demo...");
//    uLCD.text_width(4); //4X size text
//    uLCD.text_height(4);
//    uLCD.color(RED);
//    for (int i=10; i>=0; --i) {
//        uLCD.locate(1,2);
//        uLCD.printf("%2D",i);
//        wait(.5);
//    }
//    uLCD.cls();
//    uLCD.printf("Change baudrate......");
//    uLCD.baudrate(3000000); //jack up baud rate to max for fast display
//    //if demo hangs here - try lower baud rates
//    //
//    // printf text only full screen mode demo
//    uLCD.background_color(BLUE);
//    uLCD.cls();
//    uLCD.locate(0,0);
//    uLCD.color(WHITE);
//    uLCD.textbackground_color(BLUE);
//    uLCD.set_font(FONT_7X8);
//    uLCD.text_mode(OPAQUE);
//    int i=0;
//    while(i<64) {
//        if(i%16==0) uLCD.cls();
//        uLCD.printf("TxtLine %2D Page %D\n",i%16,i/16 );
//        i++; //16 lines with 18 charaters per line
//    }
//    wait(0.5);
//    //demo graphics commands
//    uLCD.background_color(BLACK);
//    uLCD.cls();
//    uLCD.background_color(DGREY);
//    uLCD.filled_circle(60, 50, 30, 0xFF00FF);
//    uLCD.triangle(120, 100, 40, 40, 10, 100, 0x0000FF);
//    uLCD.line(0, 0, 80, 60, 0xFF0000);
//    uLCD.filled_rectangle(50, 50, 100, 90, 0x00FF00);
//    uLCD.pixel(60, 60, BLACK);
//    uLCD.read_pixel(120, 70);
//    uLCD.circle(120, 60, 10, BLACK);
//    uLCD.set_font(FONT_7X8);
//    uLCD.text_mode(TRANSPARENT);
//    uLCD.text_bold(ON);
//    uLCD.text_char('B', 9, 8, BLACK);
//    uLCD.text_char('I',10, 8, BLACK);
//    uLCD.text_char('G',11, 8, BLACK);
//    uLCD.text_italic(ON);
//    uLCD.text_string("This is a test of string", 1, 4, FONT_7X8, WHITE);
//    wait(2);
// 
////Bouncing Ball Demo
//    float fx=50.0,fy=21.0,vx=1.0,vy=0.4;
//    int x=50,y=21,radius=4;
//    uLCD.background_color(BLACK);
//    uLCD.cls();
//    //draw walls
//    uLCD.line(0, 0, 127, 0, WHITE);
//    uLCD.line(127, 0, 127, 127, WHITE);
//    uLCD.line(127, 127, 0, 127, WHITE);
//    uLCD.line(0, 127, 0, 0, WHITE);
//    for (int i=0; i<1500; i++) {
//        //draw ball
//        uLCD.filled_circle(x, y, radius, RED);
//        //bounce off edge walls and slow down a bit?
//        if ((x<=radius+1) || (x>=126-radius)) vx = -.90*vx;
//        if ((y<=radius+1) || (y>=126-radius)) vy = -.90*vy;
//        //erase old ball location
//        uLCD.filled_circle(x, y, radius, BLACK);
//        //move ball
//        fx=fx+vx;
//        fy=fy+vy;
//        x=(int)fx;
//        y=(int)fy;
//    }
//}