#include "mbed.h"
#include "JPEGCamera.h"
#include "emic2.h"
 
DigitalOut myled1(LED1); //show successful picture was taken 
DigitalOut myled2(LED2); //show end of sequence
DigitalOut myled3(LED3); //show picture take failed
DigitalOut myled4(LED4); //show camera is not ready
Serial pc(USBTX, USBRX);

DigitalIn handShake(p21);
JPEGCamera camera(p9, p10); // TX, RX
emic2 myTTS(p13, p14); //serial RX,TX pins to emic
int picNum = 0;
char filename[32];
    
char* takePic(){
    LocalFileSystem local("local"); //save images on mbed
    Timer timer;
    timer.start();

    camera.setPictureSize(JPEGCamera::SIZE320x240);
    
    if (camera.isReady()) {
        sprintf(filename, "/local/pict%03d.jpg", picNum++);
        printf("Picture: %s ", filename);
        if (camera.takePicture(filename)) {
            while (camera.isProcessing()) {
                camera.processPicture();
            }
            myled1 = 1; //show successful picture was taken 
            wait(2.0);
            myled1 = 0;
        } else {
            printf("take picture failed\n");
            myled3 = 1; //show picture take failed
            wait(2.0);
            myled3 = 0;
        }
    } else {
        printf("camera is not ready\n");
        myled4 = 1; //show camera is not ready
        wait(2.0);
        myled4 = 0;
    }
        
    myled2 = 1; //show end of sequence
    wait(2.0);
    myled2 = 0;
    printf("time = %f\n", timer.read());
    
    return filename;
}


int main()
{
    myTTS.volume(18); //max volume
    while(1) {
        if (handShake == 0) {
            wait(0.5);
            //Buzz speaks
            myTTS.speakf("S");//Speak command starts with "S"
            myTTS.speakf("Hello! My name is Buzz, the GT Yellow Jacket. I am going to take a picture. Smile!", 8);  // Send the desired string to convert to speech
            myTTS.speakf("\r"); //marks end of speak command
            myTTS.ready(); //ready waits for speech to finish from last command with a ":" response
            
            char* file = takePic();
            
        }

    }
}