#include "mbed.h"
#include "Websocket.h"
#include "dnsresolve.h"
#include "EthernetNetIf.h"
#include "EE4040.h"
#include "NTPClient.h"
#include "Time.h"

//------------------Initialization----------------------//

Serial pc(USBTX, USBRX);                                // Initialize serial communication over USB
Timer tmr;                                              // Initialize a new Timer called tmr
LocalFileSystem local("local");                             // This is the directory where Halifax.csv vill be stored

// a method to update the time from a timeserver
void updateTime() {                                         // a function to update the time
    time_t ctTime;                                          // ??
    time(&ctTime);                                          // ??
    // printf("Current time is (UTC): %s\r\n", ctime(&ctTime));

    NTPClient ntp;
    Host server(IpAddr(), 123, "0.de.pool.ntp.org");            // check that this Server is OK?
    ntp.setTime(server);

    // printf("set time ok\r\n");
    time(&ctTime);
    // printf("Current time is (UTC): %s\r\n", ctime(&ctTime));

}
//------------ Connect to Server -----------------------//
Websocket ws("ws://131.202.94.104:4040");               // establish websocket connection to this server

int main() {
    void* p1=malloc(16000); // to ensure we have enough heap after NTP setup
    while (1) {                                         // Infinite loop

        if (!ws.connect()) {                            // loop here while the connection is not established
            pc.printf("Connection Failed - restart mbed\r\n");
        }
        // pc.printf("Successfully Connected!\r\n");    // Confirm connection
        tmr.start();                                    // start the Timer tmr

//----------------- DATA COLLECTION --------------------//
// Data collected from the arduino/DSP
// this is just dummy data, eventualy there will be function calls here that
// will fetch the data from the DSP/arduino
        char b[8] = {'V','1','2','0','.','0','0',';'};
        char r[8] = {'I','0','2','0','.','0','0',';'};
        char a[8] = {'P','2','4','0','0','.','0',';'};
        char n[8] = {'p','0','0','0','0','0','0',';'};
        char d[8] = {'v','0','0','0','4','8','6',';'};
        char o[8] = {'I','1','2','0','.','0','0',';'};
        int w[1] = {'w'};

        // getDataV();                                  // This will be the method call that updates the data from the DSP

// Pointers to measurements
        char V[9] = {*b,*(b+1),*(b+2),*(b+3),*(b+4),*(b+5),*(b+6),*(b+7),'\0'};
        char * ptr_V;
        ptr_V = V;
        char I[9] = {*r,*(r+1),*(r+2),*(r+3),*(r+4),*(r+5),*(r+6),*(r+7),'\0'};
        char * ptr_I;
        ptr_I = I;
        char P[9] = {*a,*(a+1),*(a+2),*(a+3),*(a+4),*(a+5),*(a+6),*(a+7),'\0'};
        char * ptr_P;
        ptr_P = P;
        char p[9] = {*n,*(n+1),*(n+2),*(n+3),*(n+4),*(n+5),*(n+6),*(n+7),'\0'};
        char * ptr_p;
        ptr_p = p;
        char v[9] = {*d,*(d+1),*(d+2),*(d+3),*(d+4),*(d+5),*(d+6),*(d+7),'\0'};
        char * ptr_v;
        ptr_v = v;
        char i[9] = {*o,*(o+1),*(o+2),*(o+3),*(o+4),*(o+5),*(o+6),*(o+7),'\0'};
        char * ptr_i;
        ptr_i = i;
        // char W[2] = {*w,'\0'};
        // char * ptr_W;
        // ptr_W = W;       // Test value in the format of scotts data

// Pointer to all the measurements
        char data[49] = {*b,*(b+1),*(b+2),*(b+3),*(b+4),*(b+5),*(b+6),*(b+7),
                         *r,*(r+1),*(r+2),*(r+3),*(r+4),*(r+5),*(r+6),*(r+7),
                         *a,*(a+1),*(a+2),*(a+3),*(a+4),*(a+5),*(a+6),*(a+7),
                         *n,*(n+1),*(n+2),*(n+3),*(n+4),*(n+5),*(n+6),*(n+7),
                         *d,*(d+1),*(d+2),*(d+3),*(d+4),*(d+5),*(d+6),*(d+7),
                         *o,*(o+1),*(o+2),*(o+3),*(o+4),*(o+5),*(o+6),*(o+7),'\0'
                        };
        char * ptr_data;                                // Declare a new Pointer
        ptr_data = data;                                // make the new pointer point to the data


//------------------ DATA PROCESSING -------------------//
// Data appended with a timestamp, formatted, and sent to the server

        // ws.send("\r\n");
        while (1) {

            if (tmr.read() > 3) {                       // Wait 3 seconds -> Send Data Every 3 seconds

                free(p1); // reclaim back memory

                char *buf=new char[32];

                Time *time=new Time();
                TimeStamp *timestamp=time->getTime();

                snprintf(buf,32,"%.2d;%.2d;%.2d;%.2d;%.2d;%.2d",
                         timestamp->getYear(),timestamp->getMonth()+1, timestamp->getDay(),
                         timestamp->getHour()-3, timestamp->getMinute(), timestamp->getSecond());
                // printf("time=%s\r\n",buf);


                // pc.printf(ptr_data);
                // pc.printf("\r\n");
                ws.send("\r\n");
                ws.send(ptr_data);
                ws.send(buf);
                // getTime();
                tmr.start();                            // restart the timer
            } // end if
            Net::poll();
        } // end while


    } // end while
} // end main