#include "Websocket.h"
#include <string>

#define DEBUG

#ifdef TARGET_LPC1768
Websocket::Websocket(char * url) {
    server_ip = NULL;
    netif = ETH;
    eth_writeable = false;
    eth_readable = false;
    eth_connected = false;
    response_server_eth = false;
    new_msg = false;
    fillFields(url);

    eth = new EthernetNetIf();
    sock = new TCPSocket();

    EthernetErr ethErr = eth->setup();
#ifdef DEBUG
    if (ethErr) {
        printf("\r\nERROR %d in setup.\r\n", ethErr);
    }
#endif

    //we must use dnsresolver to find the ip address
    if (server_ip == NULL) {
        DNSResolver dr;
        server_ip = new IpAddr();
        *server_ip = dr.resolveName(ip_domain.c_str());
#ifdef DEBUG
        printf("\r\nserver with dns=%d.%d.%d.%d\r\n", (*server_ip)[0], (*server_ip)[1], (*server_ip)[2], (*server_ip)[3]);
#endif

    }

    IpAddr ipt = eth->getIp();
#ifdef DEBUG
    printf("\r\nmbed IP Address is %d.%d.%d.%d\r\n", ipt[0], ipt[1], ipt[2], ipt[3]);
#endif

    sock->setOnEvent(this, &Websocket::onTCPSocketEvent);
}
#endif //target

void Websocket::fillFields(char * url) {
    char *res = NULL;
    char *res1 = NULL;

    char buf[50];
    strcpy(buf, url);

    res = strtok(buf, ":");
    if (strcmp(res, "ws")) {
#ifdef DEBUG
        printf("\r\nFormat error: please use: \"ws://ip-or-domain[:port]/path\"\r\n\r\n");
#endif
    } else {
        //ip_domain and port
        res = strtok(NULL, "/");

        //path
        res1 = strtok(NULL, " ");
        if (res1 != NULL) {
            path = res1;
        }

        //ip_domain
        res = strtok(res, ":");

        //port
        res1 = strtok(NULL, " ");
        //port
        if (res1 != NULL) {
            port = res1;
        } else {
            port = "80";
        }

        if (res != NULL) {
            ip_domain = res;

            //if we use ethernet, we must decode ip address or use dnsresolver
#ifdef TARGET_LPC1768
            if (netif == ETH) {
                strcpy(buf, res);

                //we try to decode the ip address
                if (buf[0] >= '0' && buf[0] <= '9') {
                    res = strtok(buf, ".");
                    int i = 0;
                    int ip[4];
                    while (res != NULL) {
                        ip[i] = atoi(res);
                        res = strtok(NULL, ".");
                        i++;
                    }
                    server_ip = new IpAddr(ip[0], ip[1], ip[2], ip[3]);
#ifdef DEBUG
                    printf("Connecting to Sever %i.%i.%i.%i...\r\n",(*server_ip)[0],(*server_ip)[1],(*server_ip)[2],(*server_ip)[3]);
#endif
                }
            }
#endif //target
        }
    }
}

bool Websocket::connect() {
    char cmd[50];
#ifdef TARGET_LPC1768
    if (netif == ETH) {
        Host server (*server_ip, atoi(port.c_str()));
        sprintf(cmd, "Just before sock->close();\r\n");
        sock->send(cmd, strlen(cmd));
        //sock->close();
        TCPSocketErr bindErr = sock->connect(server);
        if (bindErr) {
#ifdef DEBUG
            printf("\r\nERROR binderr: %d\r\n", bindErr);
#endif
            return false;
        }

        //Timer tmr;
        //tmr.start();

        //Timer stop;
        //stop.start();

#ifdef DEBUG
        printf("\r\nip_domain: %s\r\npath: /%s\r\nport: %s\r\n\r\n",this->ip_domain.c_str(), this->path.c_str(), this->port.c_str());
#endif
        return true;
    }
#endif //target
    //the program shouldn't be here
    return false;
}

void Websocket::sendLength(uint32_t len) {
    if (len < 126) {
        sendChar(len | (1 << 7));
    } else if (len < 65535) {
        sendChar(126 | (1 << 7));
        sendChar(len & 0xff);
        sendChar((len >> 8) & 0xff);
    } else {
        sendChar(127 | (1 << 7));
        for (int i = 0; i < 8; i++) {
            sendChar((len >> i * 8) & 0xff);
        }
    }
}

void Websocket::sendChar(uint8_t c) {
#ifdef TARGET_LPC1768
    if (netif == ETH) {
        Net::poll();
        sock->send((const char *)&c, 1);
    }
#endif
}

void Websocket::send(char * str) {
#ifdef TARGET_LPC1768
    if (netif == ETH) {
        Net::poll();
        sock->send(str, strlen(str));
    }
#endif //target
}

bool Websocket::read(char * message) {
    int i = 0;
    uint32_t len_msg;
    char opcode = 0;
    char mask[4] = { 0, 0, 0, 0 };
    Timer tmr;

#ifdef TARGET_LPC1768
    if (netif == ETH) {

        uint32_t index = 0;
        Net::poll();

        if (new_msg) {
            tmr.start();
            // read the opcode
            while (true) {
                if (tmr.read() > 3) {
                    return false;
                }
                opcode = eth_rx[index++];
                if (opcode == 0x81) {
                    break;
                }
            }
#ifdef DEBUG
            printf("opcode: 0x%X\r\n", opcode);
#endif

            len_msg = eth_rx[index++] & 0x7f;
            if (len_msg == 126) {
                len_msg = eth_rx[index++];
                len_msg += eth_rx[index++] << 8;
            } else if (len_msg == 127) {
                len_msg = 0;
                for (int i = 0; i < 8; i++) {
                    len_msg += eth_rx[index++] << i*8;
                }
            }
            if (len_msg == 0) {
                return false;
            }
#ifdef DEBUG
            printf("length: %d\r\n", len_msg);
#endif
            if ((len_msg & 0x80)) {
                for (int i = 0; i < 4; i++)
                    mask[i] = eth_rx[index++];
            }

            for (i = 0; i < len_msg; i++) {
                message[i] = eth_rx[index++];// ^ mask[i % 4];
            }

            message[len_msg] = 0;
            new_msg = false;
            return true;
        }
        return false;
    }
#endif //target
//the program shouldn't be here
    return false;
}

bool Websocket::close() {

#ifdef TARGET_LPC1768
    if (netif == ETH) {

        if (sock->close())
            return false;
        return true;
    }
#endif //target
    //the program shouldn't be here
    return false;
}

bool Websocket::connected() {
#ifdef TARGET_LPC1768
    if (netif == ETH) {
        return eth_connected;
    }
#endif //target
    //the program shouldn't be here
    return false;
}

std::string Websocket::getPath() {
    return path;
}

#ifdef TARGET_LPC1768
void Websocket::onTCPSocketEvent(TCPSocketEvent e) {
    if (e == TCPSOCKET_CONNECTED) {
        eth_connected = true;
#ifdef DEBUG
        printf("TCP Socket Connected\r\n");
#endif
    } else if (e == TCPSOCKET_WRITEABLE) {
    } else if (e == TCPSOCKET_READABLE) {
        int len = sock->recv(eth_rx, 512);
        eth_rx[len] = 0;
        new_msg = true;
        if (!response_server_eth) {
            string checking;
            size_t found = string::npos;
            checking = eth_rx;
            found = checking.find("DdLWT/1JcX+nQFHebYP+rqEx5xI=");
            if (found != string::npos)
                response_server_eth = true;
        }
    } else {
#ifdef DEBUG
        printf("TCP Socket Fail\r\n");
#endif
        eth_connected = false;
    }
}
#endif //target
