/*
* DNSResolver library
* Copyright (c) 2010 Hendrik Lipka
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#ifndef __DNSRESOLVE_H__
#define __DNSRESOLVE_H__

#include "Timer.h"
#include "wait_api.h"

#include "DNSRequest.h"

class DNSResolver {
public:
    DNSResolver() {
        _request=new DNSRequest();
        _request->setOnReply(this, &DNSResolver::onReply);
    };

    ~DNSResolver() {
        delete _request;
    };

    IpAddr resolveName(const char* name) {
        _completed=0;
        IpAddr addr;

        DNSRequestErr r=_request->resolve(name);
        if (0!=r) {
            _request->close();
            return addr;
        }

        mbed::Timer tmr;
        tmr.start();
        while (0==_completed) {
            Net::poll();
            if (tmr.read()>5)
                break;
            wait_us(100);
        }

        if (-1==_completed) {
            _request->close();
            return addr;
        }

        _request->getResult(&addr);
        _request->close();
        return addr;
    };

    void onReply(DNSReply reply) {
        if (reply==DNS_FOUND)
            _completed=1;
        else
            _completed=-1;
    };

private:
    DNSRequest *_request;
    int _completed; // -1=err,0=running,1=ok
};


#endif