#include "Time.h"

#include "stdio.h"
// #include "time.h"

using namespace std;

class TimeZoneEntry {
    public:
    TimeStamp *_from;
    TimeStamp *_to;
    int _offset;
};

list<TimeZoneEntry*> *Time::_timeZoneEntries=NULL;

bool TimeStamp::isSame(TimeStamp* ts)
{
    if (ts->getYear()!=getYear())
        return false;
    if (ts->getMonth()!=getMonth())
        return false;
    if (ts->getDay()!=getDay())
        return false;
    if (ts->getHour()!=getHour())
        return false;
    if (ts->getSecond()!=getSecond())
        return false;
    return true;
}
bool TimeStamp::isBefore(TimeStamp* ts)
{
    if (getYear()<ts->getYear())
        return true;
    if (getYear()>ts->getYear())
        return false;

    if (getMonth()<ts->getMonth())
        return true;
    if (getMonth()>ts->getMonth())
        return false;

    if (getDay()<ts->getDay())
        return true;
    if (getDay()>ts->getDay())
        return false;

    if (getHour()<ts->getHour())
        return true;
    if (getHour()>ts->getHour())
        return false;

    if (getSecond()<ts->getSecond())
        return true;
    return false;        
}
bool TimeStamp::isAfter(TimeStamp* ts)
{
    return ts->isBefore(this);        
}

Time::Time() {
    if (NULL==Time::_timeZoneEntries) {
        _timeZoneEntries=new list<TimeZoneEntry*>();
        readTimeZones();
    }
}

void Time::readTimeZones() {
    time_t rawtime;
    time ( &rawtime );
    TimeStamp ts(rawtime);

    int currentYear=ts.getYear();

    FILE *fp = fopen("/local/Edmonton.csv", "r");

    if (fp==NULL) {
        printf("error while reading timezone file\n");
        return;
    }


    char tmp[128]; // enough for a single line
    while (fgets(tmp,sizeof(tmp),fp)!=0) {
        int fyear, fmon, fday, fhour, fmin, fsec;
        int tyear, tmon, tday, thour, tmin, tsec;
        int offset;
        int r=sscanf(tmp,"%4d-%2d-%2dT%2d:%2d:%2dZ,%4d-%2d-%2dT%2d:%2d:%2dZ,%d",
                     &fyear, &fmon, &fday, &fhour, &fmin, &fsec,
                     &tyear, &tmon, &tday, &thour, &tmin, &tsec,
                     &offset
                    );
        if (13!=r)
            continue;
        if (fyear<currentYear || tyear>currentYear+5)
            continue;
        
        TimeStamp *from=new TimeStamp(fyear, fmon, fday, fhour, fmin, fsec);
        TimeStamp *to=new TimeStamp(tyear, tmon, tday, thour, tmin, tsec);
        TimeZoneEntry *tze=new TimeZoneEntry();
        tze->_from=from;
        tze->_to=to;
        tze->_offset=offset;
        _timeZoneEntries->push_back(tze);
    }

    fclose(fp);
}

Time::~Time() {
}

TimeStamp* Time::getTime() {
    time_t rawtime;
    time ( &rawtime );
    TimeStamp *ts=new TimeStamp(rawtime);

    for (list<TimeZoneEntry*>::iterator it = _timeZoneEntries->begin(); it != _timeZoneEntries->end(); it++) {
        TimeZoneEntry* tze=*it;
        if (tze->_from->isBefore(ts) && tze->_to->isAfter(ts))
        {
            rawtime+=tze->_offset;
            ts->updateTime(rawtime);
        }
    }
    
    return ts;
}
