#include "mbed.h"
//Adafruit MEMs SPW2430 microphone demo - LEDs display audio level
BusOut led_strip(p21,p22,p23, p24, p25, p26);
PwmOut led1(p21);
PwmOut led2(p22);
PwmOut led3(p23);
PwmOut led4(p24);
PwmOut led5(p25);
PwmOut led6(p26);

class microphone
{
public :
    microphone(PinName pin);
    float read();
    operator float ();
private :
    AnalogIn _pin;
};
microphone::microphone (PinName pin):
    _pin(pin)
{
}
float microphone::read()
{
    return _pin.read();
}
inline microphone::operator float ()
{
    return _pin.read();
}

microphone mymicrophone(p16);

int get_sound()
{
    //while(1) {
//read in, subtract 0.67 DC bias, take absolute value, and scale up .1Vpp to 15 for builtin LED display
        int val = int(abs((mymicrophone - (0.67/3.3)))*500.0);
        if(val <= 2.5){
            led_strip = 0b100000; 
        } else if (2.5 > val && val < 5){
            led_strip = 0b110000; 
        } else if (val > 5 && val < 7.5){
            led_strip = 0b111000; 
        } else if (val > 7.5 && val < 10){
            led_strip = 0b111100; 
        } else if (val > 10 && val < 12.5){
            led_strip = 0b111110; 
        } else if (val > 12.5 && val < 15){
            led_strip = 0b111111; 
        } else {
            led_strip = 0; 
        }
        wait(0.2); 
//Use an 8kHz audio sample rate (phone quality audio);
        //wait(1.0/8000.0);
  //  }
    return val; 
}
