#include "mbed.h"

#include "USBMouseKeyboard.h"
#include "IAP.h"

#define TARGET_ADDRESS (64) 

#define QUEUE_IDLE (0)
#define QUEUE_READ (1)
#define QUEUE_WRITE (2)
#define QUEUE_DUMP (3)
volatile unsigned char queue = QUEUE_IDLE;
volatile unsigned char messageLength = 0;
char buff[64];

DigitalOut myled0(P1_15), myled1(P0_23);
DigitalIn sw(P0_21, PullUp);
USBMouseKeyboard key_mouse(REL_MOUSE, 0x1FC9, 0x80BA, 0x0001);
IAP     iap;

typedef struct _hidCommand{
    uint8_t reportSize;
    uint8_t reportID;
    uint8_t report[8];
} hidCommand;

void errorLED() {
    while(1) {
        myled1 = 0;
        wait(0.1);
        myled1 = 1;
        wait(0.1);
    }
}

void key_pressed(hidCommand *command){
    int i = 0;
    while(1){
        if(command[i].reportSize == 0){
            return;
        }
        
        HID_REPORT report;
        
        report.length = command[i].reportSize+1;
        report.data[0] = command[i].reportID;
        memcpy(&report.data[1], command[i].report, command[i].reportSize);
        key_mouse.send(&report);
        
        if(report.data[0]==REPORT_ID_KEYBOARD || report.data[0]==REPORT_ID_MOUSE){
            for(int j=0;j<report.length;j++){
                report.data[j+1] = 0;
            }
            key_mouse.send(&report);
        }
        
        i++;
        wait(0.01);
    }
}

int main(void) {
    if( iap.read_eeprom( (char*)TARGET_ADDRESS, &buff[0], 64 ) ) {
        errorLED();
    }
    
    unsigned int cnt = 0, pwm = 0;
    const int pwm_resolution = 1023;
    unsigned char dir = 1, blink = 0, blink_cnt = 255;
    const unsigned char blinc_count = 8;
    
    while (1) {
        if(cnt==0){
            cnt = pwm_resolution;
        }else{
            cnt--;
        }
        // drive led
        if(blink>0){
            // blink section
            if( cnt == 0 ){
                blink_cnt--;
                if( blink_cnt == 0 ){
                    blink_cnt = 255;
                    blink--;
                    myled0 = blink & 1;
                    myled1 = blink & 1;
                }
            }
        }else{
            // dimmer section
            if(cnt==0){
                if(dir){
                    pwm++;
                    if(pwm==pwm_resolution){
                        dir = 0;
                    }
                }else{
                    pwm--;
                    if(pwm==0){
                        dir = 1;
                    }
                }
            }
            if(cnt<pwm){
                myled0 = 1;
                myled1 = 1;
            }else{
                myled0 = 0;
                myled1 = 0;
            }
        }
        
        // sw polling
        if(sw==0){
            wait(0.02);
            if(sw==0){
                key_pressed((hidCommand*)buff);
                myled0 = 1;
                myled1 = 1;
                while(sw==0);
                myled0 = 0;
                myled1 = 0;
            }
        }
        
        // queue polling
        if(queue == QUEUE_READ){
            HID_REPORT report;
            report.data[0] = REPORT_ID_UTILITY;
            report.data[1] = iap.read_eeprom( (char*)TARGET_ADDRESS, &buff[0], 64 );
            memcpy(&report.data[1], &buff[0], REPORT_PAYLOAD_SIZE);
            report.length = REPORT_PAYLOAD_SIZE + 1;
            key_mouse.send(&report);
            queue = QUEUE_IDLE;
            blink = blinc_count;
        } else if(queue == QUEUE_WRITE){
            HID_REPORT report;
            report.data[0] = REPORT_ID_UTILITY;
            report.data[1] = iap.write_eeprom( &buff[0], (char*)TARGET_ADDRESS, 64 );
            for(int i=2;i<REPORT_PAYLOAD_SIZE+1;i++){
                report.data[i] = 0;
            }
            report.length = REPORT_PAYLOAD_SIZE + 1;
            key_mouse.send(&report);
            queue = QUEUE_IDLE;
        } else if(queue == QUEUE_DUMP){
            HID_REPORT report;
            report.data[0] = REPORT_ID_UTILITY;
            memcpy(&report.data[1], &buff[0], REPORT_PAYLOAD_SIZE);
            report.length = REPORT_PAYLOAD_SIZE + 1;
            key_mouse.send(&report);
        }
    }
}

void USBMouseKeyboard::genericHidCallback(uint32_t length, uint8_t *data){
    messageLength = length;
    if(data[0] == QUEUE_READ){
        queue = QUEUE_READ;
    } else if(data[0] == QUEUE_WRITE) {
        memcpy(buff, &data[1], REPORT_PAYLOAD_SIZE-1);
        queue = QUEUE_WRITE;
    } else if(data[0] == QUEUE_DUMP) {
        queue = QUEUE_DUMP;
    }
    return;
}