
#include "mbed.h"
#include "EthernetInterface.h"
#include "Adafruit_SSD1306.h"

/*
 *    Sheild LED 
 */
//    DigitalOut rled(D9);
//    DigitalOut gled(D10);
//    DigitalOut bled(D11);
    
/*
 *    W7500 onboard LED 
 */
    DigitalOut rled(LED1);
    DigitalOut gled(LED2);
    DigitalOut bled(LED3);
    
    
    


class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};

I2CPreInit gI2C(PA_10,PA_9);

/*  
 *   set OLED  
 */
Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);


/*  
 *   LED desplay functions  
 */
void clean(){
    rled = 0;
    gled = 0;
    bled = 1;
}
void clouds(){
    rled = 0;
    gled = 0;
    bled = 0;
}
void thunderstorm(){
    while(1){
            rled = 0;
            gled = 0;
            bled = 0;
            wait(0.5);
            rled = 0;
            gled = 0;
            bled = 0;
            wait(0.5);
    };
}
void rain(){
    rled = 1;
    gled = 1;
    bled = 0;
}
void mist(){
    while(1){
            rled = 1;
            gled = 1;
            bled = 0;
            wait(0.5);
            rled = 1;
            gled = 1;
            bled = 1;
            wait(0.5);
    };
}
void haze(){
    rled = 0;
    gled = 1;
    bled = 0;
}
void fog(){
    while(1){
            rled = 1;
            gled = 0;
            bled = 0;
            wait(1.0);
            rled = 1;
            gled = 1;
            bled = 0;
            wait(1.0);
    };
}
void error(){
    rled = 1;
    gled = 1;
    bled = 1;
}

/* 
 *   main
 */
int main() {
   
    int phy_link;
    printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x03, 0x04, 0x02}; 

    EthernetInterface eth;    
    
    eth.init(mac_addr); //Use DHCP
    
    while(1){
    
    eth.connect();
    
   /* 
    *    phy link 
    */
    do{
        phy_link = eth.ethernet_link();
        printf("...");
        wait(2);
    }while(!phy_link);
    printf("\r\n");
     
    printf("IP Address is %s\r\n\r\n", eth.getIPAddress()); 
    
   /* 
    *    TCP socket connect to openweather server 
    */
    TCPSocketConnection sock;
    sock.connect("api.openweathermap.org", 80);
    
    
   /*  
    *    GET method, to request weather forecast  
    */
    char http_cmd[] = "GET /data/2.5/weather?q=Seoul,kr HTTP/1.0\n\n";
    //char http_cmd[] = "GET /data/2.5/weather?q=London,uk HTTP/1.0\n\n";
    //char http_cmd[] = "GET /data/2.5/weather?q=Berlin,de HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
   /* 
    *    get data into buffer
    */
    char buffer[1024];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server: %s\n", ret, buffer);     
    }
    printf("\r\n\r\n");
    
   /* 
    *    parsing current date, weather, city, tempurature 
    */
    char *date;
    char *weather;
    char *city;
    char *temper;
    
    char cur_date[17] = {0};
    char weather_con[15] = {0};
    char city_name[10] = {0};
    char temper_data[3] = {0};
   
    int temp;
    int num100, num10, num1;
    
   /*
    *    parding date
    */
    date = strstr(buffer, "Date");
    for(int x=0;x<17;x++){
        cur_date[x] = date[x+6];
    }
        
   /*
    *    parsing weather condition
    */ 
    weather = strstr(buffer, "main");
    for(int i=0; i<15;i++){
        weather_con[i] = weather[i+7];
        if(weather_con[i] == 34){
            weather_con[i] = 0;
            break;
        }
    }
    
   /*
    *    parsing city name
    */
    city = strstr(buffer, "name");
    for(int j=0; j<10;j++){
        city_name[j] = city[j+7];
        if(city_name[j] == 34){
            city_name[j] = 0;
            break;
        }
    }
 
   /*
    *    parsing current tempurature
    */
    temper = strstr(buffer, "temp");
    for(int k=0; k<3;k++){
        temper_data[k] = temper[k+6];
    }
       
   /*
    *    kelvin to celius converter
    */
    num100 = temper_data[0] - 48;
    num10 = temper_data[1] - 48;
    num1 = temper_data[2] - 48;
    
    temp = (num100*100 + num10*10 + num1) - 273;
    
   /* 
    *    printf  
    */
    printf("city name   :  %s\r\n",  city_name);
    printf("weather     :  %s\r\n",  weather_con);
    printf("temperature :  %d\r\n\r\n",  temp);
    
   /*   
    *    OLED Display
    */
    gOled.begin();
    gOled.clearDisplay();
    
    gOled.printf("%s\n\n", cur_date);
    gOled.printf("City    : %s\n", city_name);
    gOled.printf("Weather : %s\n", weather_con);
    gOled.printf("Temper  : %d\n", temp);
    gOled.display();
    gOled.setTextCursor(0,0);
    
   /* 
    *    LED display rely on weather condition
    */
    if(strcmp(weather_con,"Clouds")==0)            clouds();
    else if(strcmp(weather_con,"Rain")==0)         rain();
    else if(strcmp(weather_con,"Thunderstorm")==0) thunderstorm();
    else if(strcmp(weather_con,"Clean")==0)        clean();
    else if(strcmp(weather_con,"Mist")==0)         mist();
    else if(strcmp(weather_con,"Haze")==0)         haze();
    else if(strcmp(weather_con,"Fog")==0)          fog();
    else error();


    sock.close();
    
    eth.disconnect();
    
   /* 
    *    everytime in delay, request weather forecast 
    */
    wait(60.0);
    
   };

}