/******************************************************************************
 Format der Dateinamen:  Mavriqi_Besa_2_Vererbung
C++ Kurs BULME 19/20 SM
Datei 04

- Vererbung einer Basisklasse an abgeleitete Klassen

Eine Klasse kann als die Basis für die Entwicklung einer neuen Klasse verwendet 
werden, ohne dass ihr Code geändert werden muss. Dazu wird die neue Klasse 
definiert, indem angegeben wird, dass sie eine abgeleitete Klasse der 
Basisklasse ist. 

Während es in der letzten Lektion um den Aspekt der Kapselung gegangen ist,
geht es hier um den Aspekt der Vererbung. 

*******************************************************************************/
#include <stdio.h>
#include <math.h>


enum eckig { ja, nein };

class Form          // Basisklasse 
{                   
                    // In der Basisklasse werden alle gemeinsamen Variablen
  protected:          
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
 
  public:                   // sowie auch alle gemeinsamen Methoden deklariert
    float leseUmfang() { return m_umfang; }
    float leseFlaeche() { return m_flaeche; }

    Form(eckig hat_ecken);
};

Form::Form(eckig ecken) {   // im Konstruktor werden gem. Variablen initialisiert
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
};
// Hier wird eine von Form abgeleitete Klasse Kreis deklariert
class Kreis : public Form { 
    
  protected:                // Zugriffschutz protected bedeutet, dass abgeleitete 
                            // Klassen ebenfalls zugreifen können.
    float m_radius;
    
  public:                   
    float leseUmfang();
    float leseFlaeche();  //Aufgabe 2.1 - Ergänzen Sie die Klasse Kreis um die Methode float leseFlaeche();
    
    //Konstruktor hat den gleichen Name wie die Klasse
    Kreis(float radius);    // Neuer Konstruktor erfordert nur den radius 
};

Kreis::Kreis(float radius) : Form(nein) {
    // Im Konstruktor werden gleich die Membervariablen initialisiert
    
    // Über den radius werden Umfang und Fläche berechnet. 
    m_umfang = 2 * radius * M_PI;  // Die Konstante M_PI ist in math.h definiert
    m_flaeche = radius * radius * M_PI;
};

float Kreis::leseUmfang() {
                                // hier ist keine Änderung der Funktion nötig,
                                // daher wird die Funktion der Basisklasse aufger.
    return m_umfang; 
}

float Kreis::leseFlaeche() {    //hier ist auch keine Änderungder Funktion nötig
    return m_flaeche;
}
 
/*2. Leiten Sie von der Basisklasse Form die Klasse Rechteck ab
      Überlegen Sie sich welche Parameter der Konstruktur für die Klasse
      Rechteck benötigt. Implementieren sie neben dem Konstruktor auch alle 
      Methoden der Basisklasse, sodass korrekte Werte berechnet werden.*/

// Hier wird eine von Form abgeleitete Klasse Rechteck deklariert 
class Rechteck : public Form
{ 
    protected:
    float a_laenge;     //Rechteck hat die Länge a und Länge b
    float b_laenge;
    
    public:
    float leseUmfang();    //Die Methode wurde von Klasse Form abgeleitet
    float leseFlaeche();   //Die Methode wurde von Klasse Form abgeleitet
    
    //Konstruktor hat den gleichen Name wie die Klasse
    Rechteck (float a_laenge,float b_laenge); //Der neuer Konstruktor erfordert die beiden Längen
    
};
//Der Präfix Rechteck:: regelt die Zugehörigkeit der KLasse Rechteck
    Rechteck::Rechteck (float a_laenge, float b_laenge): Form(ja) 
{
    m_umfang = (2 * a_laenge) +(2 * b_laenge);  //Formel für Umfang U=2a*2b
    m_flaeche = a_laenge * b_laenge;            //Formel für Fläche A=a*a
};
// Da wird die Funktion der Basisklasse aufger.
float Rechteck::leseUmfang() { return m_umfang; }

// Da wird die Funktion der Basisklasse aufger.
float Rechteck::leseFlaeche() { return m_flaeche;}



/*
3. Optional: Leiten Sie von der Klasse Rechteck die Klasse Quadrat ab.
      Implementieren Sie Konstruktor und alle Methoden in der Form, dass 
      die Implementierungen der Klasse Rechteck genutzt werden.
      Quadrat soll eine Subklasse von Rechteck sein.*/
      
// Hier wird eine von Rechteck abgeleitete Klasse Quadrat deklariert 
class Quadrat : public Form
  {
    protected:
    float a_laenge;  
    
    public:
    float leseUmfang();
    float leseFlaeche();
    
    Quadrat (float a_laenge);  //Der Konstruktor erfordert nur eine Parameter,die Länge a
  };
 
Quadrat::Quadrat(float a_laenge) : Form(ja){
    m_umfang = a_laenge * 4; 
    m_flaeche = a_laenge* a_laenge; 
};
// Da wird die Funktion der Basisklasse aufger.
float Quadrat::leseUmfang() { return m_umfang; }

// Da wird die Funktion der Basisklasse aufger.
float Quadrat::leseFlaeche() { return m_flaeche;}


int main()
{
    printf("Wir arbeiten nun mit abgeleiteten Klassen!\n");
    printf("Es wird ein Objekt kr der Klasse Kreis erzeugt!\n");
    printf("Eswird ein Objekt re der Klasse Rechteck erzeugt!\n");
    printf("Es wird ein Objekt qu der Klasse Quadrat erzeugt!\n");
    
    Kreis kr(1.0); //Da wird zur Klasse Kreis zugegriffen,und hier wird dem Radium ein Wert zugewiesen
    Rechteck re(1.0,2.0);//Klasse Rechteckt,der Lange a und b werden Werte zugewiesen
    Quadrat qu(2.0); //Klasse Quadrat, der Länge a wird ein Wert zugewiesen
    
    float um_kr = kr.leseUmfang(); //Den Wert der Umfang aus der Klasse Kreis auslesen
    float fl_kr = kr.leseFlaeche(); //Den Wert der Fläche aus der Klasse Kreis auslesen
    float um_re = re.leseUmfang();  //Den Wert der Umfang aus der Klasse Rechteck auslesen
    float fl_re = re.leseFlaeche();  //Den Wert der Fläche aus der Klasse Rechteck auslesen
    float um_qu = qu.leseUmfang();  //Den Wert der Umfang aus der Klasse Quadrat auslesen
    float fl_qu = qu.leseFlaeche(); //Den Wert der Fläche aus der Klasse Quadrat auslesen
    
    // Und nun die Werte ausgeben
    printf("Der Umfang des Kreis ist: %f\n", um_kr);
    printf("Der Flaeche des Kreis ist: %f\n", fl_kr);
    printf("Der Umfang des Rechteck ist: %f\n", um_re);
    printf("Der Flaeche des Rechteck ist: %f\n", fl_re);
    printf("Der Umfang des Quadrat ist: %f\n", um_qu);
    printf("Der Flaeche des Quadrat ist: %f\n", fl_qu);
 
    
    return 0;
}




