#include "mbed.h"
#include "SDFileSystem.h"
#include "WavPlayer.h"
 
SDFileSystem sd(PC_12,PC_11,PC_10,PD_2,"sd"); // the pinout on the mbed Cool Components workshop board

AnalogOut dac(PA_5);
DigitalOut enb(PA_12);
WavPlayer player(&dac, &enb);

int main() {
    printf("Hello World!\n");   
    
    FILE *fp = fopen("/sd/voices/hello_0.wav", "r");
    if(fp == NULL) {
        error("Could not open file for read\n");
    }
    
    player.play(fp);
    
    fclose(fp);
    printf("Bye World!\n");   
}