#define REMOTE_PORT 49100
#define LOCAL_PORT 49101
#define BUF_SIZE 8

#include "mbed.h"
#include "EthernetInterface.h"
#include <string>

// Network interface
EthernetInterface net;
SocketAddress client;
UDPSocket server;

//Threads
Thread recv_thread;
Thread send_thread;

//Functions
void onReceive( void );
void onStream ( void );

void captureImg( void );

//Fields
char in_data[BUF_SIZE];
bool is_stopped;
string client_IP_addr;


int width = 640;
int height = 480;
std::string datagram = "";

int main()
{
    // Bring up the ethernet interface
    printf("UDP Socket example\n");
    if(0 != net.connect()) {
        printf("Error connecting\n");
        return -1;
    }

    // Show the network address
    const char *ip = net.get_ip_address();
    printf("IP address is: %s\n", ip ? ip : "No IP");

    server.open(&net);
    int err = server.bind(LOCAL_PORT);
    printf("Port status is: %d\n",err);

    recv_thread.start(onReceive);

    printf("listening has been started\n");
    printf("\n");

    while(1) {
        wait(1);
    }
}

void onReceive()
{
    int bytes;
    while(1) {
        memset(in_data, 0, sizeof(in_data));
        bytes = server.recvfrom(&client, &in_data, BUF_SIZE);

        printf("\n");
        printf("bytes received: %d\n",bytes);
        printf("string: %s\n",in_data);
        client_IP_addr = client.get_ip_address();
        printf("client address: %s\n", client_IP_addr.c_str());
        printf("\n");

        if (strcmp(in_data,"RUN") == 0) {
            send_thread.start(onStream);

            is_stopped = false;
            send_thread.signal_set(0x1);

            printf("stream on\n");

        } else if (strcmp(in_data,"STP") == 0) {
            is_stopped = true;
            printf("stream off\n");
        }
    }
}

void onStream()
{
    while(1) {
        if(is_stopped) Thread::signal_wait(0x1);

        /*/if(0 > server.sendto(client_IP_addr.c_str(), REMOTE_PORT, "TEST_STRING", sizeof("TEST_STRING"))) {
            printf("error sending data\n");
        } else printf("data has been sent\n");*/
        captureImg();
        //printf("shot\n");

        wait(1);
    }
}

/*void captureImg()
{
    bool isNew = false;
    datagram = "S";
    for(int x = 0; x < width; x++) {
        datagram += "FF";
    }
    //server.sendto(client_IP_addr.c_str(), REMOTE_PORT, datagram.c_str(), strlen(datagram.c_str()));
    //printf("strlen: %d\n",strlen(datagram.c_str()));

    for(int y = 1; y < height; y++) {
        if(isNew) {
            datagram = "R";
            isNew = false;
        } else datagram += "R";

        for(int x = 0; x < width; x++) {
            if((y%2) != 0) datagram += "FF";
            else datagram += "00";
        }

        if(((y+1)%30) == 0) {
            if(0 > server.sendto(client_IP_addr.c_str(), REMOTE_PORT, datagram.c_str(), strlen(datagram.c_str()))) printf("data hasn't been sent\n");
            else  printf("strlen: %d\n",strlen(datagram.c_str()));

            isNew = true;
        }
    }
}*/

void captureImg()
{
    datagram = "S";
    for(int x = 0; x < width; x++) {
        datagram += "FF";
    }
    server.sendto(client_IP_addr.c_str(), REMOTE_PORT, datagram.c_str(), strlen(datagram.c_str()));
    //printf("strlen: %d\n",strlen(datagram.c_str()));

    for(int y = 1; y < height; y++) {
        datagram = "R";
        for(int x = 0; x < width; x++) {
            if((y%2) != 0) datagram += "FF";
            else datagram += "00";
        }
        server.sendto(client_IP_addr.c_str(), REMOTE_PORT, datagram.c_str(), strlen(datagram.c_str()));
    }
}