#include "mbed.h"
#include "TextLCD.h"
#include <string>



//Iniciamos I2C Communication
//I2C i2c_lcd(p28,p27); // SDA, SCL
I2C i2c_lcd(p32, p31); // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2, TextLCD::HD44780); // I2C bus, PCF8574 Slaveaddress, LCD Type, Device Type

//Iniciamos el LCD.
void iniciaLCD()
{
    lcd.setMode(TextLCD::DispOn); //DispOff, DispOn
    lcd.setBacklight(TextLCD::LightOff);//LightOff, LightOn
    lcd.setCursor(TextLCD::CurOff_BlkOff);//CurOff_BlkOff, CurOn_BlkOff, CurOff_BlkOn, CurOn_BlkOn
}

//Pintamos en el LCD linea 1.
void pintaLCD1(bool manual){
    if (manual){
        lcd.locate(0,0);
        lcd.printf("     MANUAL     ");
        }
        else{
            lcd.locate(0,0);
            lcd.printf("Salida1  Salida2");
            }
    }
    
//Main, aqui ponemos todo el programa.
int main()
{
    Serial pc(USBTX, USBRX);
    iniciaLCD(); //Iniciamos el LCD
    pintaLCD1(0);
    //printf
}