#include "mbed.h"
#include "m3pi.h"
#include "manchester.h"
#include "analoog.h"

#pragma once 

// Minimum and maximum motor speeds
#define MAX_SPEED 0.22
#define MIN_SPEED 0

// PID terms
#define P_TERM 1
#define I_TERM 0
#define D_TERM 10

namespace ProjectTwo{
    
    class LineFollower{
        public:
            /*
            * Constructor for LineFollower class.
            *
            @param Nothing.
            @return Nothing.
            */
            LineFollower(void);
            
            /*
            * Most important method of this class, contains the state machine.
            *
            @param Nothing.
            @return Nothing.
            */
            void followTheLine(void);
        private:
            
            m3pi m3pi;
            Manchester vlcDecoder;
            AnalogReader analogSensor;
            
            enum lineFollowerStates{
                STATE_INIT,
                STATE_COMPUTE,
                STATE_FORWARD,
                STATE_LONG_FORWARD,
                STATE_LEFT,
                STATE_RIGHT,
                STATE_TURN180,
                STATE_STOP,
                STATE_VLC
            };
            lineFollowerStates CurrentLineFollowerState;
            
            /*
            * Method that computes the derivative.
            *
            @param Nothing.
            @return The derivate as a float.
            */
            float computeDerivative(void);
            
            /*
            * Method that computes the integral.
            *
            @param Nothing.
            @return The integral as a float.
            */
            float computeIntegral(void);
            
            /*
            * Method that computes the power.
            *
            @param Nothing.
            @return The power as a float.
            */
            float computePower(void);
            
            /*
            * Method that computes the new speeds for the robot, after the calculations.
            *
            @param Nothing.
            @return Nothing.
            */
            void computeNewSpeeds(void);
            
            /*
            * Method that checks the limits of the robot.
            *
            @param Nothing.
            @return Nothing.
            */
            void limitChecks(void);

            /*
            * Method that makes the robot turn left 90 degrees.
            *
            @param Nothing.
            @return Nothing.
            */
            void turnLeft90(void);
            
            /*
            * Method that makes the robot turn right 90 degrees.
            *
            @param Nothing.
            @return Nothing.
            */
            void turnRight90(void);
            
            /*
            * Method that makes the robot go backward.
            *
            @param Nothing.
            @return Nothing.
            */
            void goBackwards(void);
            
            /*
            * Method that makes the robot go forward.
            *
            @param Nothing.
            @return Nothing.
            */
            void goForwards(void);
            
            /*
            * Method that makes the robot 'jiggle'.
            * The purpose of this is to make the robot search the area for a LED.
            *
            @param Nothing.
            @return Nothing.
            */
            void Scan(void);
            
            /*
            * Method that uses the 2 leftmost and 2 rightmost IR sensors
            * to determine if an intersection is ahead.
            *
            @param Nothing.
            @return Nothing.
            */
            bool checkForIntersection(void);
            
            float right;
            float left;
            float current_pos_of_line;
            float previous_pos_of_line;
            float derivative,proportional,integral;
            float power;
            float speed;
    };
};