#include "mbed.h"
#include "manchester.h"
 
DigitalIn signal(p7);
Serial pc(USBTX, USBRX);
Timer timer;
int datal[] = {1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0};
int datas[] = {1,1,1,1,0,0,0,0,0,0};
 
Manchester::Manchester()
{
}
 
int Manchester::decode()
{
 
    int previous,current,begin,end=0;
    int time = 0;
    int i = 0;
    timer.start();
    while(i< DELAY) {
        previous = current;
        current = signal.read();
        if(current != previous) {
            i=0;
        }
        i++;
        wait_us(100);
    }
    i = 0;
    while(i<4) {
        end = begin;
        previous = current;
        current = signal.read();
        if(current<previous) {
            begin = timer.read_us();
            if(end != 0) {
                time +=(begin - end);
            }
            i++;
        }
 
 
    }
    float atime=((float)time/3000000);
    i=4;
    wait(atime/2);
 
    while(i<10) {
        int x = signal.read();
        wait(atime/2);
        int y = signal.read();
        wait(atime/2);
 
        if(x<y) {
            datas[i]=0;
        } else if(x>y) {
            datas[i]=1;
        }
        i++;
    }
 
    wait(1);
    printf("\n\raverage time is = %f s\n\r",atime);
    printf("with frequency %f\n\r",1/atime);
    printf("data is:");
    int direction = getDirection(datas);
    for(int j = 0; j<10; j++) {
        printf("%d",datas[j]);
    }
    printf("with direction:%d",direction);
    return direction;
}
 
int Manchester::getDirection(int* data)
{
    int direction;
    if(data[4]==0) {
        if(data[5]==0) {
            direction = 0;
        } else {
            direction = 1;
        }
    }else {
        if(data[5]==0) {
            direction = 2;
        } else {
            direction = 3;
        }
    }
    return direction;
}

 