#pragma once

#include "mbed.h"
#include "temperature.h"
#include "buzzer_music.h"
#include "lcd.h"
#include "rgb.h"
#include "potentiometer.h"

namespace ProjectOne{
    
    class Slave{
        public:
            /*
            * Constructor for Slave class.
            *
            @param The id for the slave that is selected on boot.
            @param Pointer to temperature class object.
            @param Pointer to potentiometer class object.
            @param Pointer to lcd class object.
            @param Pointer to rgb class object.
            @param Pointer to buzzermusic class object.
            @return Nothing.
            */
            Slave(int slave_id, Temperature *temperature, Potentiometer *potentiometer, LCD *lcd, RGB *rgb, BuzzerMusic *buzzerMusic);
            
            /*
            * Method that contains the slave state-machine.
            * Waits for incoming UDP packets from master.
            * Determines what type of command is received.
            * Executes method according to received command.
            * Sends acknowledgement back to the master.
            *
            @param Nothing.
            @return Nothing.
            */
            void handleIncomingFrame(void);
            
        private:
            enum slaveStates{
                STATE_INIT,
                STATE_WAIT_FOR_FRAME,
                STATE_HANDLE_FRAME,
                STATE_HANDLE_REQUEST,
                STATE_SEND_ACKNOWLEDGEMENT
            };
            
            slaveStates CurrentSlaveState;

            const static char *MASK;
            const static char *GATEWAY;
        
            int slaveId;
            
            Temperature *slaveTemp;
            Potentiometer *slavePot;
            LCD *slaveLcd;
            RGB *slaveRgb;
            BuzzerMusic *slaveBuzzerMusic;
            
            char ip_address[14];
            char *command_info[3];
            
            float temperatureValue;
            float potentiometerValue;
            string response;
        
    };
    
};
