#include "slave.h"
#include "EthernetInterface.h"
#include <stdio.h>
#include <ctype.h>

#define MAX_PACKET_SIZE 512

namespace ProjectOne{

    const char* Slave::MASK = "255.255.255.0";
    const char* Slave::GATEWAY = "192.168.0.1";
    
    EthernetInterface eth_slave;
    UDPSocket sock_slave;
    Endpoint master;
    
    Slave::Slave(int slave_id, Temperature *temperature, Potentiometer *potentiometer, LCD *lcd, RGB *rgb, BuzzerMusic *buzzerMusic)
    {
        slaveId = slave_id;
        slaveTemp = temperature;
        slavePot = potentiometer;
        slaveLcd = lcd;
        slaveRgb = rgb;
        slaveBuzzerMusic = buzzerMusic;
        CurrentSlaveState = STATE_INIT;
    }
    
    void Slave::handleIncomingFrame(void){
        char in_buffer[MAX_PACKET_SIZE];
        char ack_id[4];
        char response_array[512];
        switch(CurrentSlaveState){
            case STATE_INIT:
            {
                printf("----------------\r\n");
                printf("Initiating slave\r\n");
                printf("----------------\r\n");
                
                memset(&ip_address[0], 0, sizeof(ip_address));
                
                ip_address[0] = '1';
                ip_address[1] = '9';
                ip_address[2] = '2';
                ip_address[3] = '.';
                ip_address[4] = '1';
                ip_address[5] = '6';
                ip_address[6] = '8';
                ip_address[7] = '.';
                ip_address[8] = '0';
                ip_address[9] = '.';
                
                int temp[3];
                int i = 0;
                do{
                   temp[i] = slaveId % 10;
                   slaveId /= 10;
                   i++; 
                }while(slaveId !=0);
                
                char tempi[4];
                sprintf(tempi, "%ld", temp[2]);
                ip_address[10] = *tempi; 
                sprintf(tempi, "%ld", temp[1]);
                ip_address[11] = *tempi; 
                sprintf(tempi, "%ld", temp[0]);
                ip_address[12] = *tempi; 
                
                ip_address[13] = '\0';
                
                eth_slave.init(ip_address, MASK, GATEWAY);
                eth_slave.connect();
                
                sock_slave.bind(4000);
                
                command_info[0] = 0;
                
                CurrentSlaveState = STATE_WAIT_FOR_FRAME;
                break;
            }
            case STATE_WAIT_FOR_FRAME:
            {
                printf("Waiting for frame!\r\n");
                int n = sock_slave.receiveFrom(master, in_buffer, sizeof(in_buffer));
                in_buffer[n] = '\0';
                CurrentSlaveState = STATE_HANDLE_FRAME;
                break;
            }
            case STATE_HANDLE_FRAME:
            {
                printf("Received message from server: '%s'\r\n", in_buffer);
                
                char *p = strtok(in_buffer, " ");
                command_info[0] = p;
                char *q = strtok(NULL, " ");
                command_info[1] = q;
                char *s = strtok(NULL, '\0');
                command_info[2] = s;         
                
                ack_id[0] = ip_address[10];
                ack_id[1] = ip_address[11];
                ack_id[2] = ip_address[12];
                ack_id[3] = '\0';
                
                CurrentSlaveState = STATE_HANDLE_REQUEST;
                break;
            }
            case STATE_HANDLE_REQUEST:
            {
                slaveLcd->clearLcd(); 
                slaveRgb->turnOnLed("");
                temperatureValue = 0.0;
                potentiometerValue = 0.0;
                
                response.clear();
                memset(&response_array[0], 0, sizeof(response_array));
                
                if(strcmp(command_info[0], "PUT") == 0){
                    if(strcmp(command_info[1], "/LCD") == 0){
                        slaveLcd->displayChars(command_info[2]); 
                        response.append("ACK").append(" ").append("2.04").append(" ").append(ack_id).append("");
                    }
                    else if(strcmp(command_info[1], "/LED") == 0){
                        string kleurtje(command_info[2]);
                        slaveRgb->turnOnLed(kleurtje);
                        response.append("ACK").append(" ").append("2.04").append(" ").append(ack_id).append("");
                    }
                    else if(strcmp(command_info[1], "/BUZZER") == 0){
                        string indexes(command_info[2]);
                        slaveBuzzerMusic->playMusic(indexes);
                        response.append("ACK").append(" ").append("2.04").append(" ").append(ack_id).append("");
                    }
                    else
                    {
                    response.append("ACK").append(" ").append("4.0").append(" ").append(ack_id);
                    }

                }
                else if(strcmp(command_info[0], "GET") == 0){
                    if(strcmp(command_info[1], "/temperature") == 0){
                        temperatureValue = slaveTemp->readTemperature();
                        char temp[] = "";
                        sprintf(temp, "%.3f", temperatureValue);
                        response.append("ACK").append(" ").append("2.05").append(" ").append(ack_id).append(" ").append(temp);
                    }
                    else if(strcmp(command_info[1], "/potentiometer") == 0){
                         potentiometerValue = slavePot->getPotValue();
                         char temp[] = "";
                         sprintf(temp, "%.3f", potentiometerValue);
                         response.append("ACK").append(" ").append("2.05").append(" ").append(ack_id).append(" ").append(temp);
                    }
                    else{
                        response.append("ACK").append(" ").append("4.0").append(" ").append(ack_id);
                    }
                }
                else{
                    response.append("ACK").append(" ").append("4.0").append(" ").append(ack_id);
                }
                CurrentSlaveState = STATE_SEND_ACKNOWLEDGEMENT;
                break;
            }
            case STATE_SEND_ACKNOWLEDGEMENT:
            {
                strcpy(response_array, response.c_str());
                sock_slave.sendTo(master,(char *)response_array, 512);
 
                response.clear();

                CurrentSlaveState = STATE_WAIT_FOR_FRAME;
                break;
            }
                
        }
    }
    
    
}