#include "mbed.h"
#include "lcd.h"
#include "buzzer_music.h"
#include "rgb.h"
#include "potentiometer.h"
#include "temperature.h"
#include "slave.h"
#include "master.h"
#include "selection.h"
   
using namespace ProjectOne;

int main() {
    BuzzerMusic buzzerMusic;
    Temperature temperatureReader;
    Potentiometer potentiometerReader;
    RGB rgbLed;
    LCD lcdApplicationBoard;
    Selection selection;
    
    string mode;
    int id;
    
    mode = selection.determineMode();
    printf("The mode you selected: '%s'\r\n", mode.c_str());

    id = selection.determineId();
    printf("The id you selected is '%d'\r\n", id);
    
    if(mode == "slave"){
    Slave slave(id, &temperatureReader,&potentiometerReader,&lcdApplicationBoard,&rgbLed,&buzzerMusic);
        while(true){    
            slave.handleIncomingFrame();
        }
    }
    if(mode == "master"){
    Master master(id);
         while(true){
             master.handlePcData();
        }
    }
}


