#include "buzzer_music.h"
#include <string.h>

namespace ProjectOne{
    
    const int BuzzerMusic::frequencies[] = {110,110,110,98,130,110,98,130,110,165,165,165,175,130,104,98,130};
    const int BuzzerMusic::lengths[] = {480,480,480,360,120,480,360,120,960,480,480,480,360,120,480,360,120};
    const int BuzzerMusic::delays[] = {100,100,100,75,100,100,75,100,100,100,100,100,75,100,100,75,100};
    
    BuzzerMusic::BuzzerMusic(PinName speakerPin) : speaker(speakerPin){
        
    }

    void BuzzerMusic::playMusic(std::string indexes){
        char *command_info[2];
        int i = 0;
        char *p = strtok ((char *)indexes.c_str(), "-");
        while (p != NULL)
        {
            command_info[i++] = p;
            p = strtok (NULL, "-");
        }
        int x = atoi(command_info[0]);
        int y = atoi(command_info[1]);

        if(x >= 1 && y <= 17){
            for(int i = x; i < y; i ++){
                speaker = 0.5;
                speaker.period(1.0/frequencies[i]);
                wait((float)lengths[i]/1000);
                speaker = 0.0;
                wait((float)delays[i]/1000);
            }
            printf("Played Music\r\n");
        }else{
            printf("Indexes not valid!\r\n");
        }
        
    }

}

