#pragma once

#include "mbed.h"
#include <string>

#define MAX_ARRAY_LENGTH_RGB 7

namespace ProjectOne{
    
    class RGB{
        public:
            /*
            * Constructor for RGB class.
            *
            @param The pins that are connected to the RGB on the application board.
            @return Nothing.
            */
            RGB(PinName firstPin=p23, PinName secondPin=p24, PinName thirdPin=p25);
            
            /*
            * Method turns on the LED according to the given color.
            *
            @param A string containing the color to be displayed.
            @return Nothing.
            */
            void turnOnLed(string kleur);
        private:
            const static float r_values[MAX_ARRAY_LENGTH_RGB];
            const static float g_values[MAX_ARRAY_LENGTH_RGB];
            const static float b_values[MAX_ARRAY_LENGTH_RGB];
            PwmOut r;
            PwmOut g;
            PwmOut b;
            int determineRgbIndex(string kleur);
    };
};