#include "mbed.h"
#include "rgb.h"

namespace ProjectOne{
    
    const float RGB::r_values[] = {0.0, 1.0, 1.0, 0.0, 0.498, 0.0, 1.0};
    const float RGB::g_values[] = {1.0, 0.0, 1.0, 0.353, 1.0, 0.0, 1.0};
    const float RGB::b_values[] = {1.0, 1.0, 0.0, 1.0, 0.498, 0.0, 1.0};
    
    RGB::RGB(PinName r_pin, PinName g_pin, PinName b_pin) : r(r_pin), g(g_pin), b(b_pin){
        turnOnLed("");
    }
    
    //Rood = 0, Groen = 1, Blauw = 2, Oranje = 3, Paars = 4, Wit = 5, Uit = 6
    void RGB::turnOnLed(string kleur){
        int array_index = determineRgbIndex(kleur);
        r = r_values[array_index];
        g = g_values[array_index];
        b = b_values[array_index];
    }
    
    int RGB::determineRgbIndex(string kleur){
        if(kleur == "RED"){
            return 0;
        }
        else if(kleur == "GREEN"){
            return 1;
        }
        else if(kleur == "BLUE"){
            return 2;
        }
        else if(kleur == "ORANGE"){
            return 3;
        }
        else if(kleur == "PURPLE"){
            return 4;
        }
        else if(kleur == "WHITE"){
            return 5;
        }
        else{
            return 6;
        }
    }
    
}


